import path_setting
from in_common.base_request import BaseRequest


class doctor_request(BaseRequest):

    def __init__(self):
        self.data = self.api_load(path_setting.DOCTOR_ARTICLE_CONFIG)

    #医生/医院主页-医生说/医院说列表
    def article(self, doctor_id):
        self.params["doctor_id"] = doctor_id
        return self.api_send(self.data["article"])

    #医生主页详情
    def detail(self):
        return self.api_send(self.data["detail"])

    #医生主页案例列表
    def diary(self, doctor_id):
        self.params["doctor_id"] = doctor_id
        return self.api_send(self.data["diary"])


if __name__ == '__main__':
    #打印医生/医院主页-医生说/医院说列表接口返回
    print(doctor_request().article("9918ad7eb8f511e58f8200163e000a4a"))

    #打印医生主页详情接口返回
    print(doctor_request.detail())

    #打印医生主页案例列表接口返回
    print(doctor_request.diary("5bd9f05cad51403d853ba8c881989e23"))