import path_setting
from in_common.base_request import BaseRequest


class live_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.LIVESERVICES_CONFIG)
        self.data = self.api_load(path_setting.LIVEGIFTS_CONFIG)
        self.data = self.api_load(path_setting.SEARCHSERVICE_CONFIG)
        self.data = self.api_load(path_setting.ADDLIVESERVICE_CONFIG)
        self.data = self.api_load(path_setting.POP_SERVICE_CONFIG)
        self.data = self.api_load(path_setting.POP_GIFT_CONFIG)
        self.data = self.api_load(path_setting.GET_GIFT_CONFIG)
        self.data = self.api_load(path_setting.DELETELIVESERVICE_CONFIG)
        self.data = self.api_load(path_setting.DELETEGIFT_CONFIG)
        self.data = self.api_load(path_setting.M_GET_CHANNEL_STATUS_CONFIG)
        self.data = self.api_load(path_setting.MARK_LIVE_SERVICE_CONFIG)

    #主播-推荐袋美购列表展示
    def live_services(self, channel_id, stream_id, offset, size):
        self.params["channel_id"] = channel_id
        self.params["stream_id"] = stream_id
        self.params["offset"] = offset
        self.params["size"] = size
        return self.api_send(self.data["live_services"])

    #主播-推荐袋美券列表展示
    def live_gifts(self, channel_id, gift_type, stream_id, offset, size):
        self.params["channel_id"] = channel_id
        self.params["gift_type"] = gift_type
        self.params["stream_id"] = stream_id
        self.params["offset"] = offset
        self.params["size"] = size
        return self.api_send(self.data["live_gifts"])

    #主播-推荐袋商品捜索功能
    def search_service(self, current_city_id, channel_id, query,  offset, size, version, device_id='97B6764B-2135-4761-9911-701C38CBC272'):
        self.params["current_city_id"] = current_city_id
        self.params["channel_id"] = channel_id
        self.params["query"] = query
        self.params["offset"] = offset
        self.params["size"] = size
        self.params["version"] = version
        return self.api_send(self.data["search_service"])

    #主播-推荐袋美券捜索功能
    def search_gifts(self, current_city_id, channel_id, gift_type,  offset, size, version, device_id='97B6764B-2135-4761-9911-701C38CBC272'):
        self.params["current_city_id"] = current_city_id
        self.params["channel_id"] = channel_id
        self.params["gift_type"] = gift_type
        self.params["offset"] = offset
        self.params["size"] = size
        self.params["version"] = version
        return self.api_send(self.data["search_gifts"])



    #主播-推荐袋添加商品
    def add_live_service(self, channel_id, service_item_ids, version,  device_id='97B6764B-2135-4761-9911-701C38CBC272'):
        self.params["channel_id"] = channel_id
        self.params["service_item_ids"] = service_item_ids
        self.params["version"] = version
        return self.api_send(self.data["add_live_service"])

    #主播-添加商品后，购物车上方弹出商品卡片
    def pop_service(self, stream_id, live_service_id, pop_type, version,  device_id='97B6764B-2135-4761-9911-701C38CBC272'):
        self.params["stream_id"] = stream_id
        self.params["live_service_id"] = live_service_id
        self.params["pop_type"] = pop_type
        self.params["version"] = version
        return self.api_send(self.data["pop_service"])

    #om后台-弹出美券
    def pop_gift(self, stream_id, gift_id, version,  device_id='97B6764B-2135-4761-9911-701C38CBC272'):
        self.params["stream_id"] = stream_id
        self.params["gift_id"] = gift_id
        self.params["version"] = version
        return self.api_send(self.data["pop_gift"])

    #用户-领取美券
    def get_gift(self, gift_id, version,  device_id='97B6764B-2135-4761-9911-701C38CBC272'):
        self.params["gift_id"] = gift_id
        self.params["version"] = version
        return self.api_send(self.data["get_gift"])

    #主播-推荐袋删除商品
    def delete_live_service(self, channel_id, live_service_id, version,  device_id='97B6764B-2135-4761-9911-701C38CBC272'):
        self.params["channel_id"] = channel_id
        self.params["live_service_id"] = live_service_id
        self.params["version"] = version
        return self.api_send(self.data["delete_live_service"])

    #主播-推荐袋删除美券
    def delete_live_gift(self, channel_id, gift_id, gift_type, stream_id, version,  device_id='97B6764B-2135-4761-9911-701C38CBC272'):
        self.params["channel_id"] = channel_id
        self.params["gift_id"] = gift_id
        self.params["gift_type"] = gift_type
        self.params["stream_id"] = stream_id
        self.params["version"] = version
        return self.api_send(self.data["delete_live_gift"])

    #获取直播间状态
    def m_get_channel_status(self, channel_id, version,  device_id='97B6764B-2135-4761-9911-701C38CBC272'):
        self.params["channel_id"] = channel_id
        self.params["version"] = version
        return self.api_send(self.data["m_get_channel_status"])

    #主播标记讲解商品+取消标记
    def mark_live_service(self, stream_id, channel_id, live_service_id,  mark_status, version,  device_id='97B6764B-2135-4761-9911-701C38CBC272'):
        self.params["stream_id"] = stream_id
        self.params["channel_id"] = channel_id
        self.params["live_service_id"] = live_service_id
        self.params["mark_status"] = mark_status
        self.params["version"] = version
        return self.api_send(self.data["mark_live_service"])

    #直播-观众打开购物袋
    def audience_services(self, stream_id,channel_id,offset,size):
        self.params["stream_id"] = stream_id
        self.params["channel_id"] = channel_id
        self.params["offset"] = offset
        self.params["size"] = size
        return self.api_send(self.data["audience_services"])
    #观众点击直播内美购跳转详情页
    def service_page_live_enter(self,service_id):
        self.params["service_id"] = service_id
        return self.api_send(self.data["service_page_live_enter"])

if __name__ == '__main__':
    # print(live_request().live_services("745", "4177", "0", "10"))
    # print(live_request().search_service("beijing", "745", "", "0", "20", "7.45.0"))
    # print(live_request().add_live_service("745", "560641", "7.45.0"))
    # print(live_request().delete_live_service("745", "7242", "7.45.0"))
    #print(live_request().m_get_channel_status("745", "7.46.0"))
    # print(live_request().mark_live_service("4233", "745", "7269", "1", "746.0"))
    # print(live_request().audience_services("4179","739","0","20"))
    # print(live_request().pop_service("4266", "7324", "1", "746.0"))
    # print(live_request().pop_gift("4271", "59124", "746.0"))
    print(live_request().get_gift( "59124", "746.0"))