import path_setting
from in_common.base_request import BaseRequest


class living_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.LIVEYAML_CONFIG)
#获取弹幕
    def danmu_v2(self,channel_id,msg_id,user_id=""):
        self.params["channel_id"] = channel_id
        self.params["msg_id"] = msg_id
        self.params["user_id"] = user_id
        return self.api_send(self.data["danmu_v2"])
#主播开播git
    def pushlive_info(self,title,cover_url,notice,tag_id,clarity,device_type):
        self.params["title"] = title
        self.params["cover_url"] = cover_url
        self.params["notice"] = notice
        self.params["tag_id"] = tag_id
        self.params["clarity"] = clarity
        self.params["device_type"] = device_type
        return self.api_send(self.data["pushlive_info"])
#用户-发送弹幕
    def sendmsg(self,channel_id,msg):
        self.params["channel_id"] = channel_id
        self.params["msg"] = msg
        return self.api_send(self.data['sendmsg'])


    #观众进入直播间
    def enter(self,channel_id, from_source, version, device_id="97B6764B-2135-4761-9911-701C38CBC272"):
        self.params["channel_id"] = channel_id
        self.params["from_source"] = from_source
        self.params["version"] = version
        return self.api_send(self.data["enter"])

    #观众离开直播间
    def leave(self,channel_id, version, device_id="97B6764B-2135-4761-9911-701C38CBC272"):
        self.params["channel_id"] = channel_id
        self.params["version"] = version
        return self.api_send(self.data["leave"])

    #直播结束-主播下播
    def finish(self,channel_id, version, device_id="97B6764B-2135-4761-9911-701C38CBC272"):
        self.params["channel_id"] = channel_id
        self.params["version"] = version
        return self.api_send(self.data["finish"])

    #主播-分享按钮的点击
    def get_live_info_audience(self,channel_id, version, device_id="97B6764B-2135-4761-9911-701C38CBC272"):
        self.params["channel_id"] = channel_id
        self.params["version"] = version
        return self.api_send(self.data["get_live_info_audience"])




if __name__ == '__main__':
    (living_request().danmu_v2("739", "1"))
    (living_request().pushlive_info("小冤家", "2021/04/22/1003/cef471cff5e6", "", "1", "1", "1"))
    print (living_request().sendmsg("739","你好"))
    print(living_request().finish("745", "746.0"))
    print(living_request().get_live_info_audience("745", "7.46.0"))