import os, sys

BASE_DIR = os.path.dirname(os.path.dirname(__file__))
sys.path.append(BASE_DIR)

HOSTYAML_CONFIG = os.path.join(BASE_DIR, "backend_auto", "host.yaml")
LOGIN_FUNCTION_DATA = os.path.join(BASE_DIR, "backend_auto", "login_session_function.yaml")

APYAML_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "account_request.yaml")
LOGIN_VFC = os.path.join(BASE_DIR, "backend_auto/test_backend_data/account_data", "login_vfc.yaml")


# 日记本总接口配置
DIARY_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "diary_request.yaml")
# 日记本详情页--字段判空
DIARY_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/diary_data", "topic_data.yaml")
# 日记本关联美购
DIARY_SERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/diary_data", "diary_service.yaml")
# 日记本收藏&取消收藏
DIARY_FAVOR = os.path.join(BASE_DIR, "backend_auto/test_backend_data/diary_data", "favor.yaml")
# 日记本修改日记信息operation--目前好像直接用接口写无权限稍后解决
DIARY_OPERATION = os.path.join(BASE_DIR, "backend_auto/test_backend_data/diary_data", "diary_operation.yaml")
# 日记本创建日记贴信息-
DIARY_UPDATE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/diary_data", "diary_update.yaml")
# 日记本点赞&取消点赞
DIARY_VOTE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/diary_data", "vote.yaml")


# 日记本创建添加医院-- auto_complete 总配置项
AUTO_COMPLE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "auto_complete_request.yaml")
AUTO_COMPLE_HOSPITAL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/auto_complete_data", "hospital.yaml")
# 日记本创建添加医生
AUTO_COMPLE_DOCTOR = os.path.join(BASE_DIR, "backend_auto/test_backend_data/auto_complete_data", "doctor.yaml")


# 详情页搜索预置词--query 总配置项
QUERY_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "query_request.yaml")
QUERY_PRESET_WORDS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/query_data", "preset_words.yaml")


# 日记大图召回美购
SPU_BY_DIARY = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "sales_lead_spu_by_diary.yaml")


# 日记本进入相册页
DIARY_ALBUM_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "hybrid_diary_request.yaml")
DIARY_ALBUM = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hybrid_data", "diary_album.yaml")


# 日记本列表-日记贴点赞相关（）
DIARY_VOTE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "hybrid_api_topic_request.yaml")
DIARY_TOPIC_VOTE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hybrid_data", "api_topic_vote.yaml")


# 日记本&帖子&日记贴&帖子&问答各个详情页下方推荐内容
PERSONAL_RECOMMENDS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "personal_recommends.yaml")
PERSONAL_RECOMMENDS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/personal_data", "personal_recommends.yaml")


# 日记本列表-展示评论列表---也是总的common的配置
DIARY_COMMON_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "common_request.yaml")
# 日记本列表-一级评论展示评论列表
DIARY_COMMON_REPLY = os.path.join(BASE_DIR, "backend_auto/test_backend_data/common_data", "reply.yaml")
# 日记贴-子评论列表
TOPIC_SUB_COMMON = os.path.join(BASE_DIR, "backend_auto/test_backend_data/common_data", "sub_common.yaml")


# 日记贴-创建一级评论&二级评论
TOPIC_REPLY_CREATE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "topic_reply_create.yaml")
TOPIC_REPLY_CREATE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/topic_data", "topic_reply_create.yaml")


# 日记贴-一级评论点赞&取消点赞topicreply
TOPIC_REPLY_VOTE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "topicreply_vote.yaml")
TOPIC_REPLY_VOTE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/topic_data", "reply_vote.yaml")


# 日记贴-收藏&取消收藏--config文件代表，data代表接口
TOPIC_FAVOR_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "user_request.yaml")
TOPIC_FAVOR = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "problem_favor.yaml")


# 日记贴-topic总的接口的请求配置
TOPIC_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "topic_request.yaml")
# 日记贴-详情页内容
TOPIC_DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/topic_data", "v1.yaml")
# 日记贴-点赞&取消点赞--详情页内部
TOPIC_VOTE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/topic_data", "vote.yaml")


# 帖子详情页内容--也是总的tractate接口的配置
TRACTATE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "tractate_request.yaml")
# 帖子详情页内容
TRACTATE_DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/tractate_data", "new_detail.yaml")
# 帖子详情页--相关美购&推荐美购
TRACTATE_RELATED_SERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/tractate_data", "related_service.yaml")
# 帖子详情页--外显评论
TRACTATE_REPLY = os.path.join(BASE_DIR, "backend_auto/test_backend_data/tractate_data", "reply.yaml")
# 帖子详情页--收藏&取消收藏
TRACTATE_FAVOR = os.path.join(BASE_DIR, "backend_auto/test_backend_data/tractate_data", "favor.yaml")
# 帖子详情页--点赞&取消点赞
TRACTATE_VOTE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/tractate_data", "vote.yaml")
# 帖子详情页--一级评论创建
TRACTATE_PUBLISH_REPLY = os.path.join(BASE_DIR, "backend_auto/test_backend_data/tractate_data", "publish_reply.yaml")
# 发帖子--帖子内容创建
TRACTATE_CREATE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/tractate_data", "create.yaml")


# 发帖子--帖子医院选择
TRACTATE_HOSIPITAL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/topic_data", "to_hospital_list.yaml")
# 发帖子--帖子美购选择
TRACTATE_SERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/topic_data", "to_service_list.yaml")


# 发帖子--帖子订单选择 --也是order的总配置项
ORDER_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "order_request.yaml")
TRACTATE_ORDER = os.path.join(BASE_DIR, "backend_auto/test_backend_data/order_data", "is_exist.yaml")


# 写日记&提问题&发帖子--标签选择--也是tag的总配置项
TAG_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "tag_request.yaml")
DETAIL_TAG = os.path.join(BASE_DIR, "backend_auto/test_backend_data/tag_data", "list.yaml")


# 问答详情页--问题详情
QUESTION_DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hybrid_data", "question_v1.yaml")
# 问答详情页--回答列表
ANSWER_LIST = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hybrid_data", "question_new_answer_list.yaml")


# qa接口总的配置项--问答·相关
QA_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "qa_request.yaml")
# -问题的收藏&取消收藏
QA_FAVOR = os.path.join(BASE_DIR, "backend_auto/test_backend_data/qa_data", "favor.yaml")
# -test的文件，尝试在不动原函数的基础上加参数而不是用默认参数。--没必要
# TEST_QA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/qa_data", "test.yaml")


# 回答评论点赞&取消点赞
QA_REPLY_VOTE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hybrid_data", "answer_answer_reply_vote.yaml")


# 首页feed流tab切换--推荐商品类型tab[除必要参数外其余参数使用默认参数形式方便之后调整]
FEED_TAB_SERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "product_mall_service_home_feed.yaml")


# 首页（灰度）feed-推荐机构&推荐医生tab[除必要参数外其余参数使用默认参数形式方便之后调整]
FEED_TAB_SERVICE_DOCTORS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/service_data", "home_feed.yaml")


#搜索首页-热门搜索
KEYWORDS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "search_request.yaml")
KEYWORDS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/search_data", "keywords.yaml")

#医生后台-我的商品
SERVICE_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web2_data", "service_list.yaml")

SERVICE_URL=os.path.join(BASE_DIR, "backend_auto/all_doctor_api", "web2_request.yaml")

#医生后台-商品审核流程

SERVICE_REVIEW_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web2_data", "service_review_list.yaml")

#医生后台-新商品审核-撤回审核流程

SERVICEREVIEW_OPTION_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web2_data", "servicereview_option.yaml")

#医生后台-发布商品选择类目ACCOUNT
ACCOUNT_URL=os.path.join(BASE_DIR, "backend_auto/all_doctor_api", "web_request.yaml")
ACCOUNT_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "account_unreadbadgecount.yaml")

# 医生后台-发布商品选择类目article
ARTICLE_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "article_videotoken.yaml")

#医生后台 - 发布商品选择类目tag
TAG_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web2_data", "tag_all.yaml")

#医生后台 - 发布商品选择类目doctor
DOCTOR_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "doctor_submechanisms.yaml")


#医生后台-保存新增商品
REGISTER_URL=os.path.join(BASE_DIR, "backend_auto/all_doctor_api", "glmer_request.yaml")
REGISTER_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/glmer_data", "service_register.yaml")

#医生后台-编辑商品
DETAIL_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/glmer_data", "service_detail.yaml")

#医生后台-我的商品-下线商品
OFFLINE_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "service_offline.yaml")

#医生后台-我的商品-删除商品
DELETE_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web2_data", "service_delete.yaml")

#医生后台-编辑可标准化商品
PROPERTIES_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/glmer_data", "tag_properties.yaml")

#医生后台-商品回收站
DELETELIST_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web2_data", "service_deletelist.yaml")

#医生后台-上线商品、编辑商品
SERVICEALL_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "service_all.yaml")

#搜索首页-热门搜索
KEYWORDS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "search_request.yaml")
KEYWORDS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/search_data", "keywords.yaml")

# 首页灰度v9，精选tab
FEED_INDEXV9_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "feed_request.yaml")
FEED_INDEXV9_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/feed_data", "index_v9.yaml")

# 测颜值结果页
ONEIMAGE_SHARE_V4_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "oneimage_request.yaml")
ONEIMAGE_SHARE_V4_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/oneimage_data", "share_v4.yaml")
# 测颜值根据五官推荐美购
ONEIMAGE_RECOMEND_SERVICES_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/oneimage_data", "recomend_services.yaml")
# 测颜值结果页获取小程序二维码
XCX_GENGMEI_GET_WXACODE_UNLIMITED_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "xcx_request.yaml")
XCX_GENGMEI_GET_WXACODE_UNLIMITED_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/xcx_data", "gengmei_get_wxacode_unlimited.yaml")
# 测颜值根据标签召回日记
FACE_DIARY_CARDS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "face_request.yaml")
FACE_DIARY_CARDS_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/face_data", "diary_cards.yaml")
# 3D变脸下feed流
FACE_PLASTIC_FEEDS_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/face_data", "plastic_feeds.yaml")

# 测颜值底部feed流
SCAN_DIARY_CARDS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "scan_request.yaml")
SCAN_DIARY_CARDS_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/scan_data", "diary_cards.yaml")

# 测肤质feed流
SKIN_RECOMMEND_SERVICE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "skin_request.yaml")
SKIN_RECOMMEND_SERVICE_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/skin_data", "recommend_service.yaml")

# 测肤结果页 / AI变脸结果页
GMAI_SKIN_NEWREPORT_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "gmai_request.yaml")
GMAI_SKIN_NEWREPORT_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/gmai_data", "skin_newReport.yaml")
# 用户之前是否使用过测肤功能
GMAI_SKIN_USER_HAD_TEST_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/gmai_data", "skin_user_had_test.yaml")

# 模拟双眼皮
GMAI_EYELIDS_PLASTIC_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/gmai_data", "eyelids_plastic.yaml")
# 模拟发型
GMAI_SIMULATE_ANALYZE_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/gmai_data", "simulate_analyze.yaml")
# 获取模拟整形相关配置文件
GMAI_SIMULATE_CONF_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/gmai_data", "simulate_conf.yaml")
# 模拟双眼皮，发型，美瞳，眉毛下日记推荐（根据标签）
EYELIDS_DIARY_CARDS_CONFIG = os.path.join(BASE_DIR,"backend_auto/all_backend_api", "eyelids_request.yaml")
EYELIDS_DIARY_CARDS_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/eyelids_data", "diary_cards.yaml")

# AI变脸结果
GMAI_PLASTIC_ANALYSIS_V3_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/gmai_data", "plastic_analysis_v3.yaml")
# 3D变脸获取参数
GMAI_PLASTIC_CHECCK_STYLE_CLASSTIFY_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/gmai_data", "plastic_cheek_style_classify.yaml")
# 3D变脸
GMAI_PLASTIC_ANALYSIS_V2_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/gmai_data", "plastic_analysis_v2.yaml")

# 新版本我的美券列表
JANUS_PRODUCT_MY_LIST_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "product_my_list.yaml")
# 我的订单列表
ORDERS_MY_V2_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "orders_request.yaml")
# 订单列表
ORDERS_MY_V2_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/orders_data", "my_v2.yaml")
#我的订单-各状态订单数量
ORDER_MY_STATUS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/orders_data", "my_status.yaml")

LOGIN_PASSWD = os.path.join(BASE_DIR, "backend_auto/test_backend_data/accounts_data", "login_passwd.yaml")
LOGIN_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "accounts_request.yaml")

#医院主页详情
HDYAML_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "hospitals_request.yaml")
HOSPITAL_DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hospitals_data", "detail.yaml")
#医院主页医生列表
HOSPITAL_DOCTOR = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hospitals_data", "doctor.yaml")
#医院主页商品列表
HOSPITAL_SERVICE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "hospitals_v2_request.yaml")
HOSPITAL_SERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hospitals_v2_data", "services.yaml")
#医院主页日记列表
HOSPITAL_DIARY_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "hospital_request.yaml")
HOSPITAL_DIARY = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hospital_data", "diary.yaml")
#医生/医院主页-医生/医院说列表
DOCTOR_ARTICLE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "doctor_request.yaml")
DOCTOR_ARTICLE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/doctor_data", "article.yaml")
#医生主页详情
DOCTOR_DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/doctor_data", "detail.yaml")
#医生主页案例列表
DOCTOR_DIARY = os.path.join(BASE_DIR, "backend_auto/test_backend_data/doctor_data", "diary.yaml")
#医生主页商品列表
DOCTOR_V2_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "doctor_v2_request.yaml")
DOCTOR_V2_SERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/doctor_v2_data", "services.yaml")
#医生/医院主页-问答列表
USER_ANSWER_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "user_request.yaml")
USER_ANSWER = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "answer.yaml")

#购物车列表
SHOPCART_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "shopcart_request.yaml")
SHOPCART_LIST = os.path.join(BASE_DIR, "backend_auto/test_backend_data/shopcart_data", "list.yaml")
#购物车-猜你喜欢列表
JANUS_MINE_GUESS_YOU_LIKE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "mine_guess_you_like.yaml")

#消息列表
MY_CONVERSATION_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "my_conversation_request.yaml")
MY_CONVERSATION = os.path.join(BASE_DIR, "backend_auto/test_backend_data/my_conversation_data", "my_conversation.yaml")
DETAIL_MESSAGEID = os.path.join(BASE_DIR, "backend_auto/test_backend_data/conversation_data", "detail_messageid.yaml")

#消息
MESSAGE_READ_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "conversation_request.yaml")
MESSAGE_READ = os.path.join(BASE_DIR, "backend_auto/test_backend_data/conversation_data", "message_read.yaml")

#消息页未读数
UNREAD_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "notification_request.yaml")
UNREAD = os.path.join(BASE_DIR, "backend_auto/test_backend_data/notification_data", "unread.yaml")
#标记为已读
READALL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/notification_data", "readall.yaml")
#咨询顾问相关
CONVERSATION_DETAIL_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "im_request.yaml")
CONVERSATION_DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/im_data", "conversation_detail.yaml")
AUTO_MSG = os.path.join(BASE_DIR, "backend_auto/test_backend_data/im_data", "auto_msg.yaml")
SEND_MSG = os.path.join(BASE_DIR, "backend_auto/test_backend_data/im_data", "send_msg.yaml")
#发送消息
PRIVATE_CONVERSATION_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "private_conversation_request.yaml")
PRIVATE_CONVERSATION = os.path.join(BASE_DIR, "backend_auto/test_backend_data/private_conversation_data", "private_conversation.yaml")

HOME_V5_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "service_request.yaml")
HOME_V5=os.path.join(BASE_DIR,"backend_auto/test_backend_data/service_data","home_v5.yaml")


PERSONAL_CENTER_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "user_request.yaml")
PERSONAL_CENTER = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "personal_center.yaml")

#搜索结果页-综合/百科
CONTENTV7_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_request.yaml")
CONTENTV7 = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "content_v7.yaml")

#医院主页搜索
HOSPITALSEARCH_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_request.yaml")
HOSPITALSEARCH = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "hospital_search.yaml")

#直播
LIVEYAML_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "live_request.yaml")
#直播-获取弹幕
DANMU_V2 = os.path.join(BASE_DIR, "backend_auto/test_backend_data/live_data", "danmu_v2.yaml")
#直播-主播开播
PUSH_LIVE_INFO = os.path.join(BASE_DIR, "backend_auto/test_backend_data/live_data", "pushlive_info.yaml")
#直播-发送弹幕
SENDMSG = os.path.join(BASE_DIR, "backend_auto/test_backend_data/live_data", "sendmsg.yaml")


#商祥页-详情
JANUS_PRODUCT_DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "product_detail.yaml")
#商祥页-sku信息
JANUS_SKU_INFO = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "sku_info.yaml")
#商祥页-收藏
SERVICE_FAVOR = os.path.join(BASE_DIR, "backend_auto/test_backend_data/service_data", "service_favor.yaml")
#商祥页-分享
SERVICES_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "services_request.yaml")
SERVICES_SHARE_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/services_data", "share_data.yaml")
#商祥页-加入购物车
SHOPCART_ADD = os.path.join(BASE_DIR, "backend_auto/test_backend_data/shopcart_data", "add.yaml")
#商祥页-美券列表
HYBRID_GIFT_LIST_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "hybrid_gift_list_request.yaml")
GIFT_LIST_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hybrid_gift_list_data", "gift_list_data.yaml")
#商祥页-优惠券列表-领取
HYBRID_GET_GIFT_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "hybrid_get_gift_request.yaml")
GET_GIFT_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hybrid_get_gift_data", "get_gift_data.yaml")
#商祥页-美券列表-我的美券点击-744版本及以后-新接口
PRODUCT_COUPON_MY_LIST = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "product_coupon_my_list.yaml")
#商祥页-推荐商品列表
HYBRID_PROMOTION_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "hybrid_promotion_request.yaml")
RELATED_SERVICE_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hybrid_promotion_data", "related_service_data.yaml")

#次卡-确认订单
BEAUTY_CARD_ORDER_CONFIRM = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty_card_order_confirm.yaml")
#次卡-确认订单页面-修改手机号接口
BEAUTY_CARD_UPDATE_PHONE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty_card_update_phone.yaml")
#次卡-提交订单
BEAUTY_CARD_ORDER_SUBMIT = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty_card_order_submit.yaml")
#次卡-支付平台
BEAUTY_CARD_PAYMENT_METHOD = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty_card_payment_method.yaml")
#次卡-微信支付
BEAUTY_CARD_PREPAY_WECHAT = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty_card_prepay_wechat.yaml")
#次卡-支付宝支付
BEAUTY_CARD_PREPAY_ALIPAY = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty_card_prepay_alipay.yaml")
#次卡-订单详情
BEAUTY_CARD_PAYMENT_DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty_card_payment_detail.yaml")
#次卡-取消订单
BEAUTY_CARD_PAYMENT_DELETE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty_card_payment_delete.yaml")
#次卡-申请退款
BEAUTY_CARD_REFUND_INFO = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty_card_refund_info.yaml")
#次卡-提交退款申请
BEAUTY_CARD_REFUND_SUBMIT = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty_card_refund_submit.yaml")

# 次卡订单详情页（未使用 部分使用 和 已使用）
BEAUTY_CARD_ORDER_DETAIL_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty_card_order_detail.yaml")

#捜索结果页-医生/医院tab
CONTENTV6_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "search_request.yaml")
CONTENTV6 = os.path.join(BASE_DIR, "backend_auto/test_backend_data/search_data", "content_v6.yaml")


#品类聚合页面商品列表
TAG_SERVICE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_request.yaml")
TAG_SERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "tag_service.yaml")

#社区tab签到和招募活动
CONFIG_LIST_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "feed_request.yaml")
CONFIG_LIST = os.path.join(BASE_DIR, "backend_auto/test_backend_data/feed_data", "config_list.yaml")

#社区tabfeed流
COMMUNITY_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "feed_request.yaml")
COMMUNITY = os.path.join(BASE_DIR, "backend_auto/test_backend_data/feed_data", "community.yaml")

#品类聚合页面标签和专场
POLYMER_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_request.yaml")
POLYMER = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "polymer.yaml")

THIRD_PHONE_LOGIN_CONFIG = os.path.join(BASE_DIR,"backend_auto/all_backend_api", "thirdphonelogin_request")
THIRD_PHONE_LOGIN =os.path.join(BASE_DIR,"backend_auto/test_backend_data/account_data","login_thirdphone.yaml")

#医生医院sug列表
KEYWORDTIP_CONFIG = os.path.join(BASE_DIR,"backend_auto/all_backend_api", "janus_request.yaml")
KEYWORDTIP = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "keyword_tip.yaml")

#搜索首页-更美热门榜
HOT_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "search_request.yaml")
HOT = os.path.join(BASE_DIR, "backend_auto/test_backend_data/search_data", "hot.yaml")

#回答详情页点赞
VOTE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/answer_data", "vote.yaml")
#回答详情页取消点赞
CANCEL_VOTE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/answer_data", "cancel_vote.yaml")
#回答详情页-  一/二级评论
QUESTION_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "question_request.yaml")
REPLY_ANSWER = os.path.join(BASE_DIR, "backend_auto/test_backend_data/question_data", "reply_answer.yaml")

#回答详情页
DETAIL_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "answer_request.yaml")
DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/answer_data", "detail.yaml")
#品类聚合页面医生tab列表
HOSPITAL_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "search_request.yaml")
HOSPITAL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/search_data", "hospital.yaml")


#城市筛选器
FILTER_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "filter_request.yaml")
FILTER = os.path.join(BASE_DIR, "backend_auto/test_backend_data/filter_data", "service_home_city_v2.yaml")

#医生后台-全部私信列表
CONVERSATION=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "conversation.yaml")
#医生后台-未读私信列表
CONVERSATIONUNREADLIST=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "conversation_unread_list.yaml")
#医生后台-发送商品按钮
SERVICE=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "service.yaml")
#医生后台-发送案例
CONVERSATIONDIARY=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "conversation_diary.yaml")
#医生后台-发送优惠券
CONVERSATIONCOUPON=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "conversation_coupon.yaml")
#医生后台-发送私信
CONVERSATIONUSERID=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "conversation_user_id.yaml")

#医生后台-服务资源
ADTYPELIST=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "artemis_ad_type_list.yaml")
#医生后台-我的购物车
ADADDSHOPPINGCARTINFO=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web2_data", "artemis_ad_add_shopping_cart_info.yaml")
#医生后台-我的服务订单
ORDERLIST=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "artemis_order_list.yaml")
#医生后台-我的服务订单-已上线/待审核/待上线/已下线订单
ORDERIDDETAIL=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "artemis_order_id_detail.yaml")
#医生后台-我的服务订单-已购买订单
VALUEORDERIDDETAIL=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web2_data", "artemis_add_value_order_id_detail.yaml")
#医生后台-我的服务订单-已购买广告包
ADPACKAGEORDERDETAIL=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web2_data", "artemis_ad_packageorder_detail.yaml")
#医生后台-点点通商品-概览
CPCHOMEPAGE=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "cpc_homepage.yaml")
#医生后台-点点通内容-概览
CPCCOMMUNITYHOMEPAGE=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "cpc_community_homepage.yaml")
#医生后台-点点通内容-数据统计-内容
CPCCOMMUNITYDIARIES=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "cpc_community_diaries.yaml")
#医生后台-点点通内容-数据统计
CPCCOMMUNITYDATAINFO=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "cpc_community_data_info.yaml")
#医生后台-点点通内容-推广明细
CPCCOMMUNITYCLICKLOGS=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web_data", "cpc_community_click_logs.yaml")
#医生后台-点点通商品-品类推广管理
CPCCATEGORYPROMOTEMANAGELIST=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web2_data", "artemis_cpc_categorypromotemanage_list.yaml")
#医生后台-点点通商品-品类推广管理-新增推广品类
CPCCATEGORYQUERY=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web2_data", "artemis_cpc_category_query.yaml")
#医生后台-点点通商品-品类推广管理-新增推广品类-关联美购
CPCCATEGORYSERVICEIDS=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web2_data", "artemis_cpc_category_service_ids.yaml")



#更美次卡橱窗组件商品
VISUAL_BEAUTY_CARD_SERVICES_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "visual_beauty_card.yaml")
VISUAL_BEAUTY_CARD_SERVICES = os.path.join(BASE_DIR, "backend_auto/test_backend_data/visual_beauty_card_data", "visual_beauty_card_services.yaml")

#次卡商品列表组件筛选器
BEAUTYCARD_FILTERS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "visual_beauty_card.yaml")
BEAUTYCARD_FILTERS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/visual_beauty_card_data", "beautycard_filters.yaml")

#次卡商品列表组件商品
BEAUTYCARD_SKUS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "visual_beauty_card.yaml")
BEAUTYCARD_SKUS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/visual_beauty_card_data", "beautycard_skus.yaml")

#百科详情页-项目聚合百科
SUBWIKI_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "hybrid_request.yaml")
SUBWIKI = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hybrid_data", "sub_wiki.yaml")

#百科详情页-项目百科
WIKI_ITEM_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "wiki_request.yaml")
WIKI_ITEM = os.path.join(BASE_DIR, "backend_auto/test_backend_data/wiki_data", "wiki_item.yaml")

#百科详情页-药品（仪器、材料）百科
BASEWIKI_PRODUCT_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "hybrid_request.yaml")
BASEWIKI_PRODUCT = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hybrid_data", "basewiki_product.yaml")

#百科详情页-品牌百科
BRAND_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "hybrid_request.yaml")
BRAND = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hybrid_data", "brand.yaml")

#普通美购提交订单页
PREVIEW_V1 = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "settlement_request.yaml")
WECHAT_PAY = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "pay_request.yaml")
PREVIEW = os.path.join(BASE_DIR, "backend_auto/test_backend_data/settlement_data", "preview_v1.yaml")
PAY_V1 = os.path.join(BASE_DIR, "backend_auto/test_backend_data/settlement_data", "pay_v1.yaml")
CREATE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/settlement_data", "create_v1.yaml")
PAY = os.path.join(BASE_DIR, "backend_auto/test_backend_data/settlement_data", "pay.yaml")
SETTLEMENTDETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/settlement_data", "settlement_detail.yaml")
WECHARTPAYDATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/pay_data", "wechat_prepay.yaml")
ALIPAYDATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/pay_data", "alipay_prepay.yaml")
JUMPDATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/pay_data", "jump.yaml")
SETTLEMENTDELETE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/settlement_data", "settlement_delete.yaml")

#OM后台-登录
OMLOGIN_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_om_api", "login_request.yaml")
OMLOGIN = os.path.join(BASE_DIR, "backend_auto/test_om_data/om_login_data", "om_login.yaml")

#更美次卡-获取已添加页面次卡spu/sku列表
GET_RELATED_BC_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_om_api", "beautycard_request.yaml")
GET_RELATED_BC = os.path.join(BASE_DIR, "backend_auto/test_om_data/beautycard_data", "get_related_bc.yaml")

#更美次卡-删除/批量删除已添加页面次卡
DELETE_RELATED_BC_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_om_api", "beautycard_request.yaml")
DELETE_RELATED_BC = os.path.join(BASE_DIR, "backend_auto/test_om_data/beautycard_data", "delete_related_bc.yaml")

#更美次卡-已添加页面全部导出
EXPORT_RELATED_BC_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_om_api", "beautycard_request.yaml")
EXPORT_RELATED_BC = os.path.join(BASE_DIR, "backend_auto/test_om_data/beautycard_data", "export_related_bc.yaml")

#更美次卡-已添加页面全部导出
UPDATE_BC_RANK_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_om_api", "beautycard_request.yaml")
UPDATE_BC_RANK = os.path.join(BASE_DIR, "backend_auto/test_om_data/beautycard_data", "update_bc_rank.yaml")

#更美次卡-按次卡sku_id导入，导入校验
CHECK_SKU_IDS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_om_api", "beautycard_request.yaml")
CHECK_SKU_IDS = os.path.join(BASE_DIR, "backend_auto/test_om_data/beautycard_data", "check_sku_ids.yaml")

#更美次卡-按次卡spu_id导入，导入校验
CHECK_SPU_IDS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_om_api", "beautycard_request.yaml")
CHECK_SPU_IDS = os.path.join(BASE_DIR, "backend_auto/test_om_data/beautycard_data", "check_spu_ids.yaml")

#om-achelous
ACHELOUS_REQUEST_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_om_api", "achelous_request.yaml")
#直播-om后台-批量添加美购
BATCH_ADD_SERVICE = os.path.join(BASE_DIR, "backend_auto/test_om_data/achelous_data", "batch_add_service.yaml")

#次卡商详页
BEAUTY_CARD_DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty_card_detail.yaml")

#次卡商详页-适应机构列表
BEAUTY_CARD_SERVICE_HOSPITAL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty_card_service_hospital.yaml")

#免费招募背景图片
FREE_RECRUIT_BANNER_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "feed_request.yaml")
FREE_RECRUIT_BANNER = os.path.join(BASE_DIR, "backend_auto/test_backend_data/feed_data", "free_recruit_banner.yaml")

#免费招募活动列表
FREE_RECRUIT_LIST_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "feed_request.yaml")
FREE_RECRUIT_LIST = os.path.join(BASE_DIR, "backend_auto/test_backend_data/feed_data", "free_recruit_list.yaml")

#直播-点击【设置封面】
PAGE_RULES_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_request.yaml")
PAGE_RULES = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "page_rules.yaml")


#直播polling循环
POLLING_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_request.yaml")
POLLING = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "polling.yaml")

#主播-获取美颜效果
#BEAUTY_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_request.yaml")
BEAUTY = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty.yaml")
BEAUTY_POST = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "beauty_post.yaml")

#直播关注/取关主播
FOLLOW_ADD = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "follow_add.yaml")
FOLLOW_DEL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "follow_del.yaml")


#主播-推荐袋美购列表展示
LIVESERVICES_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_live_request.yaml")
LIVESERVICES = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_live_data", "live_services.yaml")

#主播-推荐袋美券列表展示
LIVEGIFTS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_live_request.yaml")
LIVEGIFTS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_live_data", "live_gifts.yaml")

#主播-推荐袋商品搜索功能
SEARCHSERVICE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_live_request.yaml")
SEARCHSERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_live_data", "search_service.yaml")

#主播-推荐袋美券搜索功能
SEARCHGIFTS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_live_request.yaml")
SEARCHGIFTS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_live_data", "search_gifts.yaml")

#主播-推荐袋添加商品
ADDLIVESERVICE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_live_request.yaml")
ADDLIVESERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_live_data", "add_live_service.yaml")

#主播-添加商品后，购物车上方弹出商品卡片
POP_SERVICE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_live_request.yaml")
POP_SERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_live_data", "pop_service.yaml")

#OM后台-弹出美券
POP_GIFT_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_live_request.yaml")
POP_GIFT = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_live_data", "pop_gift.yaml")

#用户-领取美券
GET_GIFT_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_live_request.yaml")
GET_GIFT = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_live_data", "get_gift.yaml")

#主播-推荐袋删除商品
DELETELIVESERVICE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_live_request.yaml")
DELETELIVESERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_live_data", "delete_live_service.yaml")

#主播-推荐袋删除美券
DELETEGIFT_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_live_request.yaml")
DELETEGIFT = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_live_data", "delete_live_gift.yaml")

#获取直播间状态
M_GET_CHANNEL_STATUS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_live_request.yaml")
M_GET_CHANNEL_STATUS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_live_data", "m_get_channel_status.yaml")

#观众进入直播间
ENTER_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "live_request.yaml")
ENTER = os.path.join(BASE_DIR, "backend_auto/test_backend_data/live_data", "enter.yaml")

#观众离开直播间
LEAVE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "live_request.yaml")
LEAVE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/live_data", "leave.yaml")

#直播结束-主播下播
FINISH_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "live_request.yaml")
FINISH = os.path.join(BASE_DIR, "backend_auto/test_backend_data/live_data", "finish.yaml")

#主播标记讲解商品+取消标记
MARK_LIVE_SERVICE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_live_request.yaml")
MARK_LIVE_SERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_live_data", "mark_live_service.yaml")
#直播-观众打开购物袋
AUDIENCE_SERVICES = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_live_data", "audience_services.yaml")
#直播-用户点击直播间美购
SERVICE_PAGE_LIVE_ENTER = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_live_data", "service_page_live_enter.yaml")

#主播-分享按钮的点击
GET_LIVE_INFO_AUDIENCE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "live_request.yaml")
GET_LIVE_INFO_AUDIENCE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/live_data", "get_live_info_audience.yaml")

#免费招募活动详情
FREE_RECRUIT_DETAIL_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "feed_request.yaml")
FREE_RECRUIT_DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/feed_data", "free_recruit_detail.yaml")

#免费招募获取用户抽奖状态
USER_STATUS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "feed_request.yaml")
USER_STATUS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/feed_data", "user_status.yaml")

#免费招募活动查看中奖名单
WINNING_USER_LIST_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "feed_request.yaml")
WINNING_USER_LIST = os.path.join(BASE_DIR, "backend_auto/test_backend_data/feed_data", "winning_user_lis.yaml")

#我的-日记
MY_DIARY_V2_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "user_request.yaml")
MY_DIARY_V2 = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "my_diary_v2.yaml")

#我的-帖子-我发布的
USER_TRACTATE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "user_request.yaml")
USER_TRACTATE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "user_tractate.yaml")


#我的-问题
MY_QUESTION_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "user_request.yaml")
MY_QUESTION = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "my_question.yaml")

#我的-收藏-日记本
FAVORS_SERVICES_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "user_request.yaml")
FAVORS_SERVICES = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "favors_services.yaml")

#我的-帖子-我回复的
REPLY_TRACTATE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "user_request.yaml")
REPLY_TRACTATE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "reply_tractate.yaml")

#我的-问题-回答
MY_ANSWER_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "user_request.yaml")
MY_ANSWER = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "my_answer.yaml")

#我的-收藏-日记本
FAVORS_DIARIES_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "user_request.yaml")
FAVORS_DIARIES = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "favors_diaries.yaml")

#我的-收藏-日记贴
FAVORS_TOPICS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "user_request.yaml")
FAVORS_TOPICS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "favors_topics.yaml")

#直播-新增标签
TAG_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "tag_request.yaml")
TAG_ADD = os.path.join(BASE_DIR, "backend_auto/test_backend_data/tag_data", "tag_add.yaml")
if __name__ == '__main__':
    print("==========",LIVEYAML_CONFIG)