## 项目规划


### 项目划分
- 总分支 master 
- 公共分支 common_dev
- 其他分支 参与项目的人每人创建一个已自己名字命名的分支，格式 dyy_dev

### 提交代码及编写规范
- ！！！切记一，在本地写代码时，一定要再三确认是在自己的分支进行改动，不要在master分支修改
- ！！！切记二：提交代码，Git add时，不要添加in_common文件里面的文件，这个是公共方法，不能随意改动，如果本地误改动了，提交后，会影响整个流程
- 为了便于项目的管理维护，参与者可以将自己的代码确保运行成功的前提下，提交到自己分支，然后每周往commo_dev
分支提交代码，负责人会将common_dev分支每周往master分支合并，参与者可每周一更新本地代码，确保自己的代码是最新的
- 本地代码提交Git仓库时，避免已经上传的代码被覆盖，请Git push之前，先操作git pull，在本地解决好冲突后，再Git push

### 项目分类及维护
- 项目围绕backend进行自动化测试，所以针对项目的分类以及命名，大家尽量以下面的规则维护

![](.readme_images/all_backend_api中Py文件class命名.png)

!![](.readme_images/项目all_backend_api命名规则.png)

![](.readme_images/test_case命名规则.png)

![](.readme_images/data命名规则.png)
- 下图是Charles的接口截图，文件夹分组以红框路径为一组
![](.readme_images/Charles参考截图.png)
### 项目文件的作用
- all_backend_api文件主要放backend请求接口的请求方法和请求参数
- in_common 文件主要放一些公用方法
- test_backend_case 文件主要针对接口请求的返回值做断言
- test_backend_data 文件主要放测试用例的case
- host.yaml 维护测试环境的配置文件
- path_setting.py 文件主要是配置yaml文件的读取路径
- login_session_function.py 文件主要提供获取session的功能，方便需登录的接口获取session  2021-4-19新增
- login_session_function.yaml login_session_function.py文件需要登录的数据  2021-4-19新增
- run.py 统一执行入口

### 关于yaml文明书写的注意事项  2021-4-19新增
- yaml文件对空格换行要求非常严格，所以书写时要特别注意
![](.readme_images/yaml文件错误示范.png)

### 如何写一个用例

- 先在all_backend_api下找到对应的模块，比如我写节点account下面的接口，那就找到account_request.py这个文件，写接口请求
```python
    def 接口名(self,对应接口参数,对应接口参数):
        self.params["参数名"] = 参数名
        self.params["参数名"] = 参数名
        self.params["参数名"] = 参数名
        return self.api_send(self.data["yaml文件中的key"])
        # self.data读取的是account_request.yaml文件中的数据
        # self.data["yaml文件中的key"]中的key是yaml文件中的login_vfc

```
![](.readme_images/request请求方法.png)

- 并且需要在该类中，读取path_setting路径中，配置的接口的yaml数据文件

![](.readme_images/接口yaml数据读取.png)

- 然后在account_request.yaml中写接口请求数据(接口路径，传参)，结构如图

![](.readme_images/yaml文件.png)


- 然后写test_data，在test_backend_data目录下，找到account_data文件，创建yaml文件，yaml文件格式介绍，如图

![](.readme_images/yaml.png)

- 将用例的路径放到path_setting.py下，这里面有2个路径需要放到里面，第一个是all_backend_api下创建的XXX_request.yaml文件
第二个是test_backend_case下创建的XXX.yaml文件

![](.readme_images/路径.png)

- 接下来写test_case，同样在test_backend_case中找到对应的模块，以account节点为例，在account_case下创建以test开头的文件，
test_login_vfc.py(必须以test开头，pytest识别用例是根据这个关键字查找)，方法构成见下图

![](.readme_images/测试用例.png)

- 如果切换环境，可以将host.py文件的域名更换

- 运行测试用例，需要先在pycharm的设置里面，改成pytest

![](.readme_images/pytest.png)

- 然后对应的用例类名前面就有绿色小三角，点击一下就可以运行了

![](.readme_images/运行pytest.png)

- 运行结果如图，可以看出来运行的接口是什么，用例名写清楚可以一目了然看到执行的case

![](.readme_images/用例结果.png)

