import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.diary_request import diary_request


class TestDiaryOperation:
    data = BaseRequest().api_load(path_setting.DIARY_OPERATION)
    diary_operation_case, diary_operation_data = get_ids(data, "diary_operation")
    @pytest.mark.parametrize("param", diary_operation_data, ids=diary_operation_case)
    def test_diary_operation(self, param):
        r = diary_request().diary_operation(param["diary_id"], param["title"], param["operation_timestamp"], param["doctor_name"], param["hospital_name"])
        result = diary_request().diary_additional_info()
        if result["error"] == 1:
            assert r["message"] == param["assert"]
        # if r["error"] == 1:
        #     assert r["message"] ==param["assert2"]




#


