import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.feed_request import feed_request


class TestConfigList:
    data = BaseRequest().api_load(path_setting.CONFIG_LIST)
    configlist_case, configlist_data = get_ids(data, "config_list")

    @pytest.mark.parametrize("param",configlist_data,ids=configlist_case)
    def test_config_list(self,param):
        r = feed_request().config_list(param["version"])
        if r["error"] == 0:
            assert r["data"]["config_list"][0]["type"] != param["assert"]
        # else:
        #      assert r["data"]["config_list"][0]["type"] == param["assert1"]




