import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.gmai_request import gmai_request

# 模拟双眼皮效果
class TestEyelidsPlastic:
    data = BaseRequest().api_load(path_setting.GMAI_EYELIDS_PLASTIC_DATA)
    eyelidsplastic_case, eyelidsplastic_data = get_ids(data, "eyelids_plastic")

    @pytest.mark.parametrize("param",eyelidsplastic_data,ids=eyelidsplastic_case)
    def test_skinnewReport(self,param):
        r = gmai_request().eyelids_plastic(param["version"], param["image_url"],param["style_id"])
        assert r["error"] == 0
        print("模拟双眼皮效果图片：  ",r["data"]["plastic_image_url"])