import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.gmai_request import gmai_request

# 3D变脸
class TestPlasticnAnalysisV2:
    data = BaseRequest().api_load(path_setting.GMAI_PLASTIC_ANALYSIS_V2_DATA)
    plasticanalysisv2_case, plasticanalysisv2_data = get_ids(data, "analysis_v2")

    @pytest.mark.parametrize("param",plasticanalysisv2_data,ids=plasticanalysisv2_case)
    def test_plastic_analysis_v3(self,param):
        r = gmai_request().plastic_analystic_v2(param["device_id"], param["image_url"], param["landmark"],param["cheek_style_classify_id"])
        if r["error"] == 0:
            faces = r["data"]["faces"]
            assert len(faces) > 0, f'3D变脸没有返回风格脸，请查看 {len(faces)}'
            # 分析信息,取默认第一条
            card_info = faces[0]["card_info"]
            analyze = card_info.get("analyze")
            level = card_info.get("level")
            # content = card_info.get("content")
            print(analyze,level)
