import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.gmai_request import gmai_request

# 获取模拟整形相关配置数据，双眼皮，美瞳，眉毛和发型
class TestSimulateConf:
    data = BaseRequest().api_load(path_setting.GMAI_SIMULATE_CONF_DATA)
    simulateconf_case, simulateconf_data = get_ids(data, "simulate_conf")

    @pytest.mark.parametrize("param",simulateconf_data,ids=simulateconf_case)
    def test_plastic_conf(self,param):
        r = gmai_request().simulate_conf(param["type_id"])
        assert r["error"] == 0

        # 模拟发型数据,发型类型
        hairdos = r["data"]["hairdo_configs"]["hairdos"]
        assert len(hairdos) > 0
        # 美瞳
        colorcon = r["data"]["colorcon_configs"]["colorcon"]
        # 眉毛
        eyebrow = r["data"]["eyebrow_configs"]["eyebrow"]
        # 双眼皮
        eyelids = r["data"]["eyelid_configs"]["eyelids"]