import pytest
from ids_list import get_ids
import path_setting
from all_backend_api.janus_request import janus_request
from in_common.base_request import BaseRequest


class TestSalesLeadSpuByDiary:
    data = BaseRequest().api_load(path_setting.SPU_BY_DIARY)
    sales_lead_spu_by_diary_case, sales_lead_spu_by_diary_data = get_ids(data, "sales_lead_spu_by_diary")

    @pytest.mark.parametrize("param",sales_lead_spu_by_diary_data, ids=sales_lead_spu_by_diary_case)
    def test_sales_lead_spu_by_diary(self,param):
        r = janus_request().sales_lead_spu_by_diary(param["diary_id"])
        if r["error"] == 0:
            assert r["error"] == param["assert"]
            if param["spu_info"] == 1:
                assert r["data"]["spu_info"]
            else:
                assert r["data"]["spu_info"] is None


