import pytest

import path_setting
from all_backend_api.janus_live_request import live_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestGetGift:
    data = BaseRequest().api_load(path_setting.GET_GIFT)
    get_gift_case, get_gift_data = get_ids(data, "get_gift")

    @pytest.mark.parametrize("param", get_gift_data, ids=get_gift_case)

    def test_get_gift(self,param):
        r = live_request().get_gift(param["gift_id"], param["version"])
        if r["message"] == "领取成功！":
            print("用户成功领取美券~")
            assert r["data"]["has_gift_left"] == param["assert"]
        else:
            print("出错了！！！")