import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.qa_request import qa_request


class TestFavor:
    data = BaseRequest().api_load(path_setting.QA_FAVOR)
    favor_case, favor_data = get_ids(data, "favor")

    @pytest.mark.parametrize("param", favor_data, ids=favor_case)
    def test_favor(self, param):
        r = qa_request().favor(param["answer_id"])
        assert r["error"] == param["error"]

        r = qa_request().cancelfavor(param["answer_id"])
        assert r["error"] == param["error"]











