import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.search_request import search_request


class TestHospital:
    data = BaseRequest().api_load(path_setting.HOSPITAL)
    hospital_case, hospital_data = get_ids(data, "hospital")

    @pytest.mark.parametrize("param", hospital_data, ids=hospital_case)
    def test_hospital(self, param):
        r = search_request().hospital(param["cp_id"], param["tag_id"], param["q"], param["count"], param["device_id"])
        # print('feng=', r)

        if r["error"] == 0:
         assert r["data"] != param["assert"]
