import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.tractate_request import tractate_request


class TestFavor:
    data = BaseRequest().api_load(path_setting.TRACTATE_FAVOR)
    favor_case, favor_data = get_ids(data, "favor")

    @pytest.mark.parametrize("param", favor_data, ids=favor_case)
    def test_favor(self, param):
        r = tractate_request().favor(param["tractate_id"], param["data_type"])
        # print(r)
        if r["error"] == 0:
            assert r["message"] == param["message1"]
        if r["error"] == 1:
            assert r["message"] ==param["message2"]

        r = tractate_request().cancelfavor(param["tractate_id"], param["data_type"])
        # print(r)
        if r["error"] == 0:
            assert r["message"] == param["message3"]
        if r["error"] == 1:
            assert r["message"] == param["message2"]










