import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.tractate_request import tractate_request


class TestPublishReply:
    data = BaseRequest().api_load(path_setting.TRACTATE_PUBLISH_REPLY)
    publishreply_case, publishreply_data = get_ids(data, "publish_reply")

    @pytest.mark.parametrize("param", publishreply_data, ids=publishreply_case)
    def test_publish_reply(self, param):
        r = tractate_request().publish_reply(param["tractate_id"], param["data_type"], param["reply_id"], param["content"])
        # print(r)
        assert r["error"] == param["error"]
        if r["error"] == 0:
            assert r["data"]["reply_data"]["content"] is not None and r["data"]["reply_data"]["content"] is not ""
            assert r["data"]["reply_data"]["user_type"] is not None and r["data"]["reply_data"]["user_type"] is not ""
            assert r["data"]["reply_data"]["user_gm_url"] is not None and r["data"]["reply_data"]["user_gm_url"] is not ""
            assert r["data"]["reply_data"]["is_vote"] is not None and r["data"]["reply_data"]["is_vote"] is not ""
            assert r["data"]["reply_data"]["id"] is not None and r["data"]["reply_data"]["id"] is not ""
            assert r["data"]["reply_data"]["user_portrait"] is not None and r["data"]["reply_data"]["user_portrait"] is not ""
            assert r["data"]["reply_data"]["vote_num"] is not None and r["data"]["reply_data"]["vote_num"] is not ""
            assert r["data"]["reply_data"]["content"] is not None and r["data"]["reply_data"]["content"] is not ""
            assert r["data"]["reply_data"]["reply_count"] is not None and r["data"]["reply_data"]["reply_count"] is not ""
            assert r["data"]["reply_data"]["user_name"] is not None and r["data"]["reply_data"]["user_name"] is not ""
            assert r["data"]["reply_data"]["content"]  == param["content"]







