import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web_request import web_request


class TestArtemisAdTypeList:
    data = BaseRequest().api_load(path_setting.ADTYPELIST)
    adtypelist_case, adtypelist_data = get_ids(data, "artemis_ad_type_list")


    @pytest.mark.parametrize("param",adtypelist_data,ids=adtypelist_case)
    def test_artemis_ad_type_list(self, param):
        '''服务资源列表'''
        r = web_request().artemis_ad_type_list()
        if r["error"] == 0:
            adtypes = r.get("data").get("adtypes", [])
            assert len(adtypes) >= param["assert"]

