import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web_request import web_request


class TestArtemisOrderList:
    data = BaseRequest().api_load(path_setting.ORDERLIST)
    orderlist_case, orderlist_data = get_ids(data, "artemis_order_list")


    @pytest.mark.parametrize("param",orderlist_data,ids=orderlist_case)
    def test_artemis_order_list(self, param):
        '''我的服务订单'''
        r = web_request().artemis_order_list(param["status"], param["page"])
        if r["error"] == 0:
            orders = r.get("data").get("orders", [])
            assert len(orders) >= param["assert"]
        if r["error"] == 300002:
            assert r["message"] == param["assert_message"]

