import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web_request import web_request


class TestCpcCommunityDataInfo:
    data = BaseRequest().api_load(path_setting.CPCCOMMUNITYDATAINFO)
    cpccommunitydatainfo_case, cpccommunitydatainfo_data = get_ids(data, "cpc_community_data_info")


    @pytest.mark.parametrize("param",cpccommunitydatainfo_data,ids=cpccommunitydatainfo_case)
    def test_cpc_community_data_info(self, param):
        '''点点通内容-数据统计'''
        r = web_request().cpc_community_data_info(param["diary_id"], param["start_time"], param["end_time"])
        if r["error"] == 0:
            click_list = r.get("data").get("click_list", [])
            paid_list = r.get("data").get("paid_list", [])
            time_list = r.get("data").get("time_list", [])
            assert len(click_list) <= param["assert"]
            assert len(paid_list) <= param["assert"]
            assert len(time_list) <= param["assert"]



