import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web_request import web_request


class TestService:
    data = BaseRequest().api_load(path_setting.SERVICE)
    service_case, service_data = get_ids(data, "service")


    @pytest.mark.parametrize("param",service_data,ids=service_case)
    def test_service(self, param):
        '''未读私信列表'''
        r = web_request().service()
        if r["error"] == 0:
            data = r.get("data").get("data", [])
            assert len(data) <= param["assert"]
            assert r["data"]["size"] <= param["assert_size"]

