import path_setting
from in_common.base_request import BaseRequest


class diary_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.DIARY_CONFIG)

    # 收藏
    def diary_isfavor(self):
        return self.api_send(self.data["isfavor"])

    # 取消收藏
    def diary_cancelfavor(self):
        return self.api_send(self.data["cancelfavor"])

    # 更新日记本信息
    def diary_operation(self, diary_id, title, operation_timestamp, doctor_name, hospital_name):
        self.params["diary_id"] = diary_id
        self.params["title"] = title
        self.params["operation_timestamp"] = operation_timestamp
        self.params["doctor_name"] = doctor_name
        self.params["hospital_name"] = hospital_name
        return self.api_send(self.data["operation"])

    # 添加信息--待争议
    def diary_additional_info(self):
        return self.api_send(self.data["operation"])

    # 详情页-内容
    def diary_data(self, current_city_id, diary_referrer, sort, count , start_num):
        self.params["current_city_id"] = current_city_id
        self.params["diary_referrer"] = diary_referrer
        self.params["sort"] = sort
        self.params["count"] = count
        self.params["start_num"] = start_num
        return self.api_send(self.data["diary_data"])

    # 日记本美购相关
    def diary_service(self, diary_id, service_id):
        self.params["diary_id"] = diary_id
        self.params["service_id"] = service_id
        return self.api_send(self.data["diary_service"])

    # 日记更新
    def diary_update(self, topic_list):
        self.params["topic_list"] = topic_list
        return self.api_send(self.data["update"])

    # 日记本卡片点赞
    def diary_vote(self, diary_id):
        self.params["diary_id"] = diary_id
        return self.api_send(self.data["vote"])

    # 日记本卡片取消点赞
    def diary_cancel_vote(self, diary_id):
        self.params["diary_id"] = diary_id
        return self.api_send(self.data["cancel_vote"])
