import path_setting
from in_common.base_request import BaseRequest


class web2_request(BaseRequest):
    def __init__(self):
        self.SERVICE_URL = self.api_load(path_setting.SERVICE_URL)
        # self.SERVICE_REVIEW_URL = self.api_load(path_setting.SERVICE_REVIEW_URL)

    def service_list(self, page,pagesize,is_online,extra_filter_choice):
        #我的商品查询列表
        self.params["page"] = page
        self.params["pagesize"] = pagesize
        self.params["is_online"] = is_online
        self.params["extra_filter_choice"] = extra_filter_choice
        return self.api_send(self.SERVICE_URL["service_list"])

    def service_review_list(self,page,pagesize,type):
        #商品审核查询列表
        self.params["page"] = page
        self.params["pagesize"] = pagesize
        self.params["type"] = type
        return self.api_send(self.SERVICE_URL["service_review_list"])

    def servicereview_option(self,id, type,csrfmiddlewaretoken):
        #商品审核-撤回审核、取消申请
        self.params["id"] = id
        self.params["type"] = type
        self.params["csrfmiddlewaretoken"] = csrfmiddlewaretoken
        return self.api_send(self.SERVICE_URL["servicereview_option"])

    def tag_all(self) :
        #发布商品-选择类目跳转发布商品页面tag接口
        return self.api_send(self.SERVICE_URL["tag_all"])

    def service_delete(self,is_delete,service_register_id,csrfmiddlewaretoken):
        #我的商品-删除商品
        self.params["is_delete"] = is_delete
        self.params["service_register_id"] = service_register_id
        self.params["csrfmiddlewaretoken"] = csrfmiddlewaretoken
        return self.api_send(self.SERVICE_URL["service_delete"])

    def service_deletelist(self,page):
        #我的商品-商品回收站
        self.params["page"] = page
        return self.api_send(self.SERVICE_URL["service_deletelist"])

    def artemis_ad_add_shopping_cart_info(self):
        #我的购物车
        return self.api_send(self.SERVICE_URL["artemis_ad_add_shopping_cart_info"])
    def artemis_add_value_order_id_detail(self):
        "我的服务订单-已购买"
        return self.api_send(self.SERVICE_URL["artemis_add_value_order_id_detail"])
    def artemis_ad_packageorder_detail(self, package_order_id):
        "我的服务订单-已支付广告包"
        self.params["package_order_id"] = package_order_id
        return self.api_send(self.SERVICE_URL["artemis_ad_packageorder_detail"])
    def artemis_cpc_categorypromotemanage_list(self, promote_flag,id):
        "点点通商品-品类推广管理"
        self.params["promote_flag"] = promote_flag
        self.params["id"] = id
        return self.api_send(self.SERVICE_URL["artemis_cpc_categorypromotemanage_list"])

    def artemis_cpc_category_query(self, doctor_id, flag_relation):
        "点点通商品-品类推广管理-新增推广品类"
        self.params["doctor_id"] = doctor_id
        self.params["flag_relation"] = flag_relation
        return self.api_send(self.SERVICE_URL["artemis_cpc_category_query"])


if __name__ == '__main__':
    print(web2_request().service_list("1", "10", "-1", "-1"))
    print(web2_request().service_review_list("1", "10", "0"))
    print(web2_request().servicereview_option("209989", "1", "PC8uTySuxipukIMuqNV1OPB376C2ZZ3g"))
    print(web2_request().tag_all())
    print(web2_request().service_delete("1","209863","PC8uTySuxipukIMuqNV1OPB376C2ZZ3g"))
    print(web2_request().service_deletelist("1"))#商品回收站
    print(web2_request().artemis_ad_add_shopping_cart_info())
    print(web2_request().artemis_add_value_order_id_detail())
    print(web2_request().artemis_ad_packageorder_detail("685529883901"))
    print(web2_request().artemis_cpc_categorypromotemanage_list(-1,-1))
    print(web2_request().artemis_cpc_category_query("wangyang", 0))

