import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.gmai_request import gmai_request

# AI测颜值,目前测试环境没有召回日记，先保证请求成功
class TestPlasticnAnalysisV3:
    data = BaseRequest().api_load(path_setting.GMAI_PLASTIC_ANALYSIS_V3_DATA)
    plasticanalysisv3_case, plasticanalysisv3_data = get_ids(data, "analysis_v3")

    @pytest.mark.parametrize("param",plasticanalysisv3_data,ids=plasticanalysisv3_case)
    def test_plastic_analysis_v3(self,param):
        r = gmai_request().plastic_analysis_v3(param["device_id"], param["image_url"], param["landmark"],param["cheek_style_classify_id"])
        assert r["error"] == 0
        # 风格脸
        face_analytics_info = r["data"]["face_analytics_info"]
        assert len(face_analytics_info) > 0
        for item in face_analytics_info:
            name = item["name"]
            # 脸型科普
            kepu_text = item["analytics_info"]["unscramble"][0]["content_items"][0]["text"]
            # print(name,kepu_text)
            assert name not in (None, "")
            assert kepu_text not in (None, "")
            # 模拟整形方向
            content_items = item["analytics_info"]["unscramble"][1]["content_items"]
            for con in content_items:
                text = con["text"]
                # print(text)
                assert text not in (None, "")
            # 模拟整形方案
            recommends = item["analytics_info"]["project"]["recommends"]
            assert len(recommends) == 8
            for ser in recommends:
                text = ser["text"]
                tag_name = ser["tag_name"]
                gengmei_url = ser["gengmei_url"]
                assert text not in (None, "")
                assert tag_name not in (None, "")
                assert gengmei_url == "gengmei://search_result?q={}&searchTabType=8".format(tag_name)


