import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.hybrid_request import hybrid_request


class TestAnswerAnswerReplyVote:
    data = BaseRequest().api_load(path_setting.QA_REPLY_VOTE)
    answeranswerreplyvote_case, answeranswerreplyvote_data = get_ids(data, "answer_reply_vote")

    @pytest.mark.parametrize("param", answeranswerreplyvote_data, ids=answeranswerreplyvote_case)
    def test_answer_answer_reply_vote(self, param):
        # 直接点赞，看是否能点赞，如果返回1，就直接进入取消点赞
        vote = hybrid_request().answer_reply_vote(param["id"])
        if vote["error"] == 0:
            # 校验二次点赞无效
            vote = hybrid_request().answer_reply_vote(param["id"])
            assert vote["message"] == param["assert3"]
            assert vote["error"] == 1
            # 取消点赞，回到取消点赞的状态
            cancelvote = hybrid_request().answer_reply_cancel_vote(param["id"])
            assert cancelvote["error"] == 0
        else:
            assert vote["error"] == 1
            assert vote["message"] == param["assert3"]
            # 取消点赞，回到取消点赞的状态
            cancelvote = hybrid_request().answer_reply_cancel_vote(param["id"])
            assert cancelvote["error"] == 0







