import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.hybrid_request import hybrid_request



class TestQuestionNewAnswerList:
    data = BaseRequest().api_load(path_setting.ANSWER_LIST)
    questionnewanswerlist_case, questionnewanswerlist_data = get_ids(data, "question_new_answer_list")

    @pytest.mark.parametrize("param", questionnewanswerlist_data, ids=questionnewanswerlist_case)
    def test_question_v1(self, param):
        r = hybrid_request().question_new_answer_list(param["question_id"])
        if r["error"] == 0:
            if r["data"]["answers_list"]:
                # 看下是否有回答
                assert r["data"]["answer_total_nums"] is not None and r["data"]["answer_total_nums"] is not ""
                assert r["data"]["answers_list"][0]["is_author"] is not None and r["data"]["answers_list"][0]["is_author"] is not ""
                assert r["data"]["answers_list"][0]["content_level"] is not None and r["data"]["answers_list"][0]["content_level"] is not ""
                assert r["data"]["answers_list"][0]["first_reply_count"] is not None and r["data"]["answers_list"][0]["first_reply_count"] is not ""
                assert r["data"]["answers_list"][0]["content"] is not None and r["data"]["answers_list"][0]["content"] is not ""
                assert r["data"]["answers_list"][0]["comment_count"] is not None and r["data"]["answers_list"][0]["comment_count"] is not ""
                assert r["data"]["answers_list"][0]["like_num"] is not None and r["data"]["answers_list"][0]["like_num"] is not ""
                assert r["data"]["answers_list"][0]["is_voted"] is not None and r["data"]["answers_list"][0]["is_voted"] is not ""
                assert r["data"]["answers_list"][0]["id"] is not None and r["data"]["answers_list"][0]["id"] is not ""
                assert r["data"]["answers_list"][0]["answer_id"] is not None and r["data"]["answers_list"][0]["answer_id"] is not ""
        else:
            assert r["message"] == param["message"]
            assert r["message"] == param["message"]









# 如果没有点过赞，就先校验点赞之后再取消点赞。【最后保持取消点赞的状态】






