import pytest

from all_backend_api.janus_request import janus_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestBeautyCardOrderSubmit:
    data = BaseRequest().api_load(path_setting.BEAUTY_CARD_ORDER_SUBMIT)
    beauty_card_order_submit_case, beauty_card_order_submit_data = get_ids(data, "beauty_card_order_submit")

    @pytest.mark.parametrize("param", beauty_card_order_submit_data, ids=beauty_card_order_submit_case)
    def test_beauty_card_order_submit(self, param):
        r = janus_request().beauty_card_order_submit(param["phone"], param["sku_id"], param["number"],
                                                     param["is_doctor_see"], param["gain_coupon_id"],
                                                     param["deduction_price"])

        if param["is_doctor_see"] == 1 and param["number"] == 1:
            assert r["error"] == param["assert_error"]
            assert r["data"]["status"] == param["assert_status"]
        if param["is_doctor_see"] == 0 and param["number"] == 1:
            assert r["error"] == param["assert_error"]
            assert r["data"]["status"] == param["assert_status"]
        if param["number"] == 2:
            assert r["error"] == param["assert_error"]
            assert r["data"]["status"] == param["assert_status"]

