import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.janus_request import janus_request


class TestPageRules:
    data = BaseRequest().api_load(path_setting.PAGE_RULES)
    page_rules_case, page_rules_data = get_ids(data, "page_rules")

    @pytest.mark.parametrize("param", page_rules_data, ids=page_rules_case)
    def test_page_rules(self, param):
        r = janus_request().page_rules(param["version"], param["current_city_id"], param["page_name"])

        if r["error"] == 0:
             assert r["error_code"] == param["assert"]
