import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.query_request import query_request



class TestPresetWords:
    data = BaseRequest().api_load(path_setting.QUERY_PRESET_WORDS)
    preset_words_case, preset_words_data = get_ids(data, "preset_words")

    @pytest.mark.parametrize("param", preset_words_data, ids=preset_words_case)
    def test_PresetWords(self, param):
        r = query_request().preset_words(param["id"], param["type"])
        # 因问答详情页接口返回不一样所以加了个标示位
        key = "is_question_answer"
        if param["is_preset_words"] == 1:
            assert len(r["data"]["tags"]) == param["len"]
        else:
            if key in param.keys():
                assert len(r["data"]["tags"]) == param["len"]
            else:
                assert len(r["data"]) == param["len"]









