import pytest

import path_setting
from all_backend_api.orders_request import orders_request
from ids_list import get_ids
from in_common.base_request import BaseRequest
from all_backend_api.settlement_request import settlement_request


class TestSettlementDelete:
    data = BaseRequest().api_load(path_setting.SETTLEMENTDELETE)
    delete_case, delete_data = get_ids(data, "settlement_delete")

    @pytest.mark.parametrize("param", delete_data, ids=delete_case)
    def test_settlement_delete(self, param):
        r = orders_request().my_v2(param["start_num"],param["status"],param["version"])
        for item in r["data"]["orders"]:
            if item["type"] == 1:
                item = item
                break
        # print("999999999999999",item["settlement_id"])
        if item["settlement_status"] == "0":
            id = item["settlement_id"]
            r = settlement_request().delete(id,param["cancel_reason_value"])
            assert r["message"] == param["assert"]
        else:
            print("无可取消订单")

        # print(r)
        # if r["error"] == 0:
        #     assert r["error"] == param["assert"]
        # else:
        #     assert r["error"] == param["assert"]

