import pytest

from all_backend_api.shopcart_request import shopcart_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestAdd:
    data = BaseRequest().api_load(path_setting.SHOPCART_ADD)
    add_case, add_data = get_ids(data, "add")

    @pytest.mark.parametrize("param", add_data, ids=add_case)
    def test_add(self, param):
        r = shopcart_request().add(param["from_live"], param["number"], param["service_item_id"])

        if r["error"] == 0:
            assert r["message"] == param["assert_message"]
