import pytest
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.tag_request import tag_request


class TestList:
    data = BaseRequest().api_load(path_setting.DETAIL_TAG)
    tag_list_case, tag_list_data = get_ids(data,"list")

    @pytest.mark.parametrize("param", tag_list_data, ids=tag_list_case)
    def test_to_hospital_list(self,param):
        r = tag_request().list()
        assert r["error"] == 0
        assert len(r["data"]) > 0
        # if r["error"] == 0:
        #     assert r["data"]["result"] is True