import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.tractate_request import tractate_request

class TestRelatedService:
    data = BaseRequest().api_load(path_setting.TRACTATE_RELATED_SERVICE)
    related_service_case, related_service_data = get_ids(data, "related_service")

    @pytest.mark.parametrize("param", related_service_data, ids=related_service_case)
    def test_related_service(self, param):
        r = tractate_request().tractate_related_service( param["current_city_id"], param["tractate_id"], param["data_type"] )
        # print(r)
        assert r["error"] == param["assert_error"]
        if r["error"] == 0:
            # 先判断有没有美购，然后判断里面需要的那些字段，如点赞字段，日记总数等，不传值，传空值
            if r["data"]["consult_info"]:
                assert r["data"]["consult_info"]["service_id"] is not None and r["data"]["consult_info"]["service_id"] is not "" # 美购id
                assert r["data"]["consult_info"]["doctor_user_id"] is not None and r["data"]["consult_info"]["doctor_user_id"] is not "" # 医生id
                assert r["data"]["display_service_gray"] is not None and r["data"]["display_service_gray"] is not "" # 是否展示吸顶美购灰度
                assert r["data"]["consult_info"]["service_id"] == r["data"]["related_services"][0]["id"]     # 校验关联美购id是否正确
                assert r["data"]["new_recommend_service"] is not None and r["data"]["new_recommend_service"] is not "" # 校验推荐美购是否存在

    #

        #     assert r["data"]["text"] == param["assert_text"]
        # if r["error"] == 21001:
        #     assert r["message"] == param["assert_message1"]