import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.user_request import user_request


class TestFavorsDiaries:
    data = BaseRequest().api_load(path_setting.FAVORS_DIARIES)
    favors_diaries_case, favors_diaries_data = get_ids(data, "favors_diaries")

    @pytest.mark.parametrize("param", favors_diaries_data, ids=favors_diaries_case)
    def test_favors_diaries(self, param):
        r = user_request().favors_diaries(param["start_num"], param["count"])

        assert r["error"] == param["assert"]

