import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.user_request import user_request


class TestFavorsTopics:
    data = BaseRequest().api_load(path_setting.FAVORS_TOPICS)
    favors_topics_case, favors_topics_data = get_ids(data, "favors_topics")

    @pytest.mark.parametrize("param", favors_topics_data, ids=favors_topics_case)
    def test_favors_topics(self, param):
        r = user_request().favors_topics(param["start_num"], param["count"])

        assert r["error"] == param["assert"]

