import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.user_request import user_request


class TestMyDiaryV2:
    data = BaseRequest().api_load(path_setting.MY_DIARY_V2)
    mydiaryv2_case, mydiaryv2_data = get_ids(data, "my_diary_v2")

    @pytest.mark.parametrize("param", mydiaryv2_data, ids=mydiaryv2_case)
    def test_my_diary_v2(self, param):
        r = user_request().my_diary_v2(param["start_num"], param["count"])

        if r["error"] == 0:
         # assert r["data"]["diaries"] >= param["assert"]
         assert len(r["data"]["diaries"]) >= param["assert"]

