import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web2_request import web2_request


class TestArtemisAdPackageorderDetail:
    data = BaseRequest().api_load(path_setting.ADPACKAGEORDERDETAIL)
    adpackageorderdetail_case, adpackageorderdetail_data = get_ids(data, "artemis_ad_packageorder_detail")


    @pytest.mark.parametrize("param",adpackageorderdetail_data,ids=adpackageorderdetail_case)
    def test_artemis_ad_packageorder_detail(self, param):
        '''我的服务订单-已支付广告包'''
        r = web2_request().artemis_ad_packageorder_detail(param["package_order_id"])
        print(r)
        if r["error"] == 0:
            advertise_source = r.get("data").get("info").get("advertise_source", [])
            #ExtendValue["info"] = json.loads(ExtendValue["info"])
            assert len(advertise_source) > param["assert"]



