import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web_request import web_request


class TestConversation:
    data = BaseRequest().api_load(path_setting.CONVERSATION)
    conversation_case, conversation_data = get_ids(data, "conversation")


    @pytest.mark.parametrize("param",conversation_data,ids=conversation_case)
    def test_conversation(self, param):
        '''全部私信列表'''
        r = web_request().conversation(param["is_star"], param["page"])
        if r["error"] == 0:
            conversation = r.get("data").get("conversation", [])
            assert len(conversation) <= param["assert"]
            assert r["data"]["size"] <= param["assert_size"]

