import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web_request import web_request


class TestCpcCommunityClickLogs:
    data = BaseRequest().api_load(path_setting.CPCCOMMUNITYCLICKLOGS)
    cpccommunityclicklogs_case, cpccommunityclicklogs_data = get_ids(data, "cpc_community_click_logs")


    @pytest.mark.parametrize("param",cpccommunityclicklogs_data,ids=cpccommunityclicklogs_case)
    def test_cpc_community_click_logs(self, param):
        '''点点通内容-数据统计'''
        r = web_request().cpc_community_click_logs(param["page"])
        if r["error"] == 0:
            click_list = r.get("data").get("click_list", [])
            assert len(click_list) >= param["assert"]



