import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web_request import web_request


class TestCpcCommunityDiaries:
    data = BaseRequest().api_load(path_setting.CPCCOMMUNITYDIARIES)
    cpccommunitydiaries_case, cpccommunitydiaries_data = get_ids(data, "cpc_community_diaries")


    @pytest.mark.parametrize("param",cpccommunitydiaries_data,ids=cpccommunitydiaries_case)
    def test_cpc_community_diaries(self, param):
        '''点点通-概览'''
        r = web_request().cpc_community_diaries()
        if r["error"] == 0:
            diaries = r.get("data").get("diaries", [])
            assert len(diaries) >= param["assert"]


