import path_setting
from in_common.base_request import BaseRequest


class web2_request(BaseRequest):
    def __init__(self):
        self.SERVICE_URL = self.api_load(path_setting.SERVICE_URL)
        # self.SERVICE_REVIEW_URL = self.api_load(path_setting.SERVICE_REVIEW_URL)

    def service_list(self, page,pagesize,is_online,extra_filter_choice):
        self.params["page"] = page
        self.params["pagesize"] = pagesize
        self.params["is_online"] = is_online
        self.params["extra_filter_choice"] = extra_filter_choice
        return self.api_send(self.SERVICE_URL["service_list"])

    def service_review_list(self,page,pagesize,type):
        self.params["page"] = page
        self.params["pagesize"] = pagesize
        self.params["type"] = type
        return self.api_send(self.SERVICE_URL["service_review_list"])

    def servicereview_option(self,id, type,csrfmiddlewaretoken):
        self.params["id"] = id
        self.params["type"] = type
        self.params["csrfmiddlewaretoken"] = csrfmiddlewaretoken
        return self.api_send(self.SERVICE_URL["servicereview_option"])


    def tag_all(self) :
        return self.api_send(self.SERVICE_URL["tag_all"])


if __name__ == '__main__':
    print(web2_request().service_list("1", "10", "-1", "-1"))
    print(web2_request().service_review_list("1", "10", "0"))
    print(web2_request().servicereview_option("209989", "1", "PC8uTySuxipukIMuqNV1OPB376C2ZZ3g"))
    print(web2_request().tag_all())
