import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.answer_request import answer_request

class TestVote:
    data = BaseRequest().api_load(path_setting.VOTE)
    vote_case, vote_data = get_ids(data, "vote")

    @pytest.mark.parametrize("param", vote_data, ids=vote_case)
    def test_vote(self, param):
        r = answer_request().vote(param["answer_id"])
        if r["error"] == 1:
            assert r["message"] == param["assert"]
