import pytest

from all_backend_api.hospitals_request import hospitals_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestDoctor:
    data = BaseRequest().api_load(path_setting.HOSPITAL_DOCTOR)
    doctor_case, doctor_data = get_ids(data, "doctor")

    @pytest.mark.parametrize("param", doctor_data, ids=doctor_case)
    def test_doctor(self, param):
        r = hospitals_request().doctor()

        assert r["error"] == param["assert_error"]
        assert r["data"][0]["id"] == param["assert_id"]
        assert r["data"][0]["doctor_name"] == param["assert_name"]
        assert r["data"][0]["good_at"][0] == param["assert_good_at"]
        assert r["data"][0]["cases"][0]["name"] == param["assert_cases"]
        assert r["data"][0]["title"] == param["assert_title"]






