import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.question_request import question_request

class TestReplyAnswer:
    data = BaseRequest().api_load(path_setting.REPLY_ANSWER)
    replyanswer_case, replyanswer_data = get_ids(data, "reply_answer")

    @pytest.mark.parametrize("param", replyanswer_data, ids=replyanswer_case)
    def test_reply_answer(self, param):
        r = question_request().reply_answer(param["current_city_id"],param["answer_id"],param["content"],param["user_id"])
        if r["message"] == "操作成功":
          assert r["message"] == param["assert"]
