import path_setting
from in_common.base_request import BaseRequest


class feed_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.FEED_INDEXV9_CONFIG)
        self.data = self.api_load(path_setting.CONFIG_LIST_CONFIG)
        self.data = self.api_load(path_setting.COMMUNITY_CONFIG)


    def index_v9(self,tabtype,version,current_city_id):
        self.params["tabtype"] = tabtype
        self.params["version"] = version
        self.params["current_city_id"] = current_city_id

        return self.api_send(self.data["index_v9"])

    #社区tab页签到和招募活动列表
    def config_list(self,version):
        self.params["version"] = version

        return self.api_send(self.data["config_list"])

    # 社区tab页feed流
    def community(self, version, tabtype, tags_id, tab_id):
        self.params["version"] = version
        self.params["tabtype"] = tabtype
        self.params["tags_id"] = tags_id
        self.params["tab_id"] = tab_id

        return self.api_send(self.data["community"])


if __name__ == '__main__':
    print(feed_request().index_v9("choice", "7.42.2",  "beijing"))

    #社区tab页签到和招募活动列表
    print(feed_request().config_list())

    #社区tab页签到和招募活动列表
    print(feed_request().community())