import path_setting
from in_common.base_request import BaseRequest


class im_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.CONVERSATION_DETAIL_CONFIG)

    def conversation_detail(self,current_city_id,begin_msg_id,conversation_type,end_msg_id,referrer):
        self.params["current_city_id"] = current_city_id
        self.params["begin_msg_id"] = begin_msg_id
        self.params["conversation_type"] = conversation_type
        self.params["end_msg_id"] = end_msg_id
        self.params["referrer"] = referrer
        return self.api_send(self.data["conversation_detail"])

    def auto_msg(self,version,uqid,trace_id,conversation_id):
        self.params["version"] = version
        self.params["uqid"] = uqid
        self.params["trace_id"] = trace_id
        self.params["conversation_id"] = conversation_id
        return self.api_send(self.data["auto_msg"])

if __name__ == '__main__':
    print(im_request().conversation_detail("beijing", 0, 4, 0,  "message_home"))
    print("第二个接口")
    print(im_request().auto_msg("7.42.2","1B519701-A4F5-453E-9D99-140B5AF697A0","2021/04/22/1722/70a1791606d5",368))




