import path_setting
from in_common.base_request import BaseRequest


class janus_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.CONTENTV7_CONFIG)
        self.data = self.api_load(path_setting.HOSPITALSEARCH_CONFIG)

        #品类聚合页面商品列表
        self.data = self.api_load(path_setting.TAG_SERVICE_CONFIG)

        #品类聚合页面标签和专场
        self.data = self.api_load(path_setting.POLYMER_CONFIG)

    #搜索结果页-综合/百科tab
    def content_v7(self, query, device_id, current_city_id, version, is_first, tab_type, offset):
        #搜索词
        self.params['query'] = query
        #设备号
        self.params['device_id'] = device_id
        #当前城市
        self.params['current_city_id'] = current_city_id
        #APP版本
        self.params['version'] = version
        #是否为第一次请求
        self.params['is_first'] = is_first
        #类型
        self.params['tab_type'] = tab_type
        #请求的页数 0，10，20
        self.params['offset'] = offset

        return self.api_send(self.data['content_v7'])

    #医院主页搜索
    def hospital_search(self, query, device_id, hospital_id, current_city_id, version, offset, size):
        #搜索词
        self.params['query'] = query
        #设备号
        self.params['device_id'] = device_id
        #医院id
        self.params['hospital_id'] = hospital_id
        #当前城市
        self.params['current_city_id'] = current_city_id
        #APP版本
        self.params['version'] = version
        #请求的页数 0，10，20
        self.params['offset'] = offset
        # 单页请求数量
        self.params['size'] = size

        return self.api_send(self.data['hospital_search'])

    #购物车-猜你喜欢列表
    def mine_guess_you_like(self):
        return self.api_send(self.data["mine_guess_you_like"])

    #商祥页-详情
    def product_detail(self, service_id, service_item_id, version):
        self.params["service_id"] = service_id
        self.params["service_item_id"] = service_item_id
        self.params["version"] = version
        return self.api_send(self.data["product_detail"])

    #商祥页-sku信息
    def sku_info(self, service_id, service_item_id):
        self.params["service_id"] = service_id
        self.params["service_item_id"] = service_item_id
        return self.api_send(self.data["sku_info"])

    # 品类聚合页面商品列表
    def tag_service(self, size, tag_ids, offset, tag_id, version, device_id):
        print("fgx")
        self.params['size'] = size
        self.params['tag_ids'] = tag_ids
        self.params['offset'] = offset
        self.params['tag_id'] = tag_id
        self.params['version'] = version
        self.params['device_id'] = device_id

        return self.api_send(self.data["tag_service"])

    # 品类聚合页面标签和专场
    def polymer(self, version, category_polymer_id, device_id):
        print("fgx")
        self.params['version'] = version
        self.params['category_polymer_id'] = category_polymer_id
        self.params['device_id'] = device_id

        return self.api_send(self.data["polymer"])


if __name__ == '__main__':
    #打印购物车-猜你喜欢列表接口返回
    print(janus_request().mine_guess_you_like())
    #打印商祥页-详情接口返回
    print(janus_request().product_detail("5857263", "618788", "7.43.0"))
    #打印商祥页-sku信息接口返回
    print(janus_request().sku_info("5857263", "618788"))

    #品类聚合页面商品列表接口返回
    print(janus_request().tag_service())
    print("fgx")

    #品类聚合页面标签和专场
    print(janus_request().polymer())
    print("fgx")


