import path_setting
from in_common.base_request import BaseRequest


class search_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.KEYWORDS_CONFIG) #keywords路径
        self.data = self.api_load(path_setting.CONTENTV6_CONFIG) #content_v6路径

    #搜索首页-热门搜索模块（点击搜索框即调接口）
    def keywords(self,current_city_id,search_tab):
        self.params["current_city_id"] = current_city_id
        self.params["search_tab"] = search_tab
        return self.api_send(self.data["keywords"])

    #搜索结果页-医生/医院tab
    def content_v6(self, query, device_id, current_city_id, version, is_first, tab_type, offset, size):
        #搜索词
        self.params['query'] = query
        #设备号
        self.params['device_id'] = device_id
        #当前城市
        self.params['current_city_id'] = current_city_id
        #APP版本
        self.params['version'] = version
        #是否为第一次请求
        self.params['is_first'] = is_first
        #类型
        self.params['tab_type'] = tab_type
        #请求的页数 0，10，20
        self.params['offset'] = offset
        # 请求的size
        self.params['size'] = size
        return self.api_send(self.data["content_v6"])