import os, sys

BASE_DIR = os.path.dirname(os.path.dirname(__file__))
sys.path.append(BASE_DIR)

HOSTYAML_CONFIG = os.path.join(BASE_DIR, "backend_auto", "host.yaml")
LOGIN_FUNCTION_DATA = os.path.join(BASE_DIR, "backend_auto", "login_session_function.yaml")

APYAML_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "account_request.yaml")
LOGIN_VFC = os.path.join(BASE_DIR, "backend_auto/test_backend_data/account_data", "login_vfc.yaml")

DIARY_DATA_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "diary_data_request.yaml")
DIARY_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/account_data", "diary_data.yaml")



#搜索首页-热门搜索
KEYWORDS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "search_request.yaml")
KEYWORDS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/search_data", "keywords.yaml")

SERVICE_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web2_data", "service_list.yaml")
SERVICE_URL=os.path.join(BASE_DIR, "backend_auto/all_doctor_api", "web2_request.yaml")



#搜索首页-热门搜索
KEYWORDS_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "search_request.yaml")
KEYWORDS = os.path.join(BASE_DIR, "backend_auto/test_backend_data/search_data", "keywords.yaml")

SERVICE_DATA=os.path.join(BASE_DIR, "backend_auto/test_doctor_data/web2_data", "service_list.yaml")
SERVICE_URL=os.path.join(BASE_DIR, "backend_auto/all_doctor_api", "web2_request.yaml")



# 首页灰度v9，精选tab
FEED_INDEXV9_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "feed_request.yaml")
FEED_INDEXV9_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/feed_data", "index_v9.yaml")

# 测颜值结果页
ONEIMAGE_SHARE_V4_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "oneimage_request.yaml")
ONEIMAGE_SHARE_V4_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/oneimage_data", "share_v4.yaml")
# 测颜值根据五官推荐美购
ONEIMAGE_RECOMEND_SERVICES_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/oneimage_data", "recomend_services.yaml")
# 测颜值结果页获取小程序二维码
XCX_GENGMEI_GET_WXACODE_UNLIMITED_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "xcx_request.yaml")
XCX_GENGMEI_GET_WXACODE_UNLIMITED_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/xcx_data", "gengmei_get_wxacode_unlimited.yaml")

# 测肤结果页 / AI变脸结果页
GMAI_SKIN_NEWREPORT_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "gmai_request.yaml")
GMAI_SKIN_NEWREPORT_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/gmai_data", "skin_newReport.yaml")
# 模拟双眼皮
GMAI_EYELIDS_PLASTIC_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/gmai_data", "eyelids_plastic.yaml")
# 模拟发型
GMAI_SIMULATE_ANALYZE_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/gmai_data", "simulate_analyze.yaml")
# 获取模拟整形相关配置文件
GMAI_SIMULATE_CONF_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/gmai_data", "simulate_conf.yaml")
# 模拟双眼皮，发型，美瞳，眉毛下日记推荐（根据标签）
EYELIDS_DIARY_CARDS_CONFIG = os.path.join(BASE_DIR,"backend_auto/all_backend_api", "eyelids_request.yaml")
EYELIDS_DIARY_CARDS_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/eyelids_data", "diary_cards.yaml")

# AI变脸结果
GMAI_PLASTIC_ANALYSIS_V3_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/gmai_data", "plastic_analysis_v3.yaml")
# 3D变脸
GMAI_PLASTIC_ANALYSIS_V2_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/gmai_data", "plastic_analysis_v2.yaml")


LOGIN_PASSWD = os.path.join(BASE_DIR, "backend_auto/test_backend_data/accounts_data", "login_passwd.yaml")
LOGIN_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "accounts_request.yaml")

#医院主页详情
HDYAML_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "hospitals_request.yaml")
HOSPITAL_DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hospitals_data", "detail.yaml")
#医院主页医生列表
HOSPITAL_DOCTOR = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hospitals_data", "doctor.yaml")
#医院主页商品列表
HOSPITAL_SERVICE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "hospitals_v2_request.yaml")
HOSPITAL_SERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hospitals_v2_data", "services.yaml")
#医院主页日记列表
HOSPITAL_DIARY_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "hospital_request.yaml")
HOSPITAL_DIARY = os.path.join(BASE_DIR, "backend_auto/test_backend_data/hospital_data", "diary.yaml")
#医生/医院主页-医生/医院说列表
DOCTOR_ARTICLE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "doctor_request.yaml")
DOCTOR_ARTICLE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/doctor_data", "article.yaml")
#医生主页详情
DOCTOR_DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/doctor_data", "detail.yaml")
#医生主页案例列表
DOCTOR_DIARY = os.path.join(BASE_DIR, "backend_auto/test_backend_data/doctor_data", "diary.yaml")
#医生主页商品列表
DOCTOR_V2_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "doctor_v2_request.yaml")
DOCTOR_V2_SERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/doctor_v2_data", "services.yaml")
#医生/医院主页-问答列表
USER_ANSWER_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "user_request.yaml")
USER_ANSWER = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "answer.yaml")

#购物车列表
SHOPCART_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "shopcart_request.yaml")
SHOPCART_LIST = os.path.join(BASE_DIR, "backend_auto/test_backend_data/shopcart_data", "list.yaml")
#购物车-猜你喜欢列表
JANUS_MINE_GUESS_YOU_LIKE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "mine_guess_you_like.yaml")

#消息列表
MY_CONVERSATION_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "my_conversation_request.yaml")
MY_CONVERSATION = os.path.join(BASE_DIR, "backend_auto/test_backend_data/my_conversation_data", "my_conversation.yaml")

HOME_V5_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "service_request.yaml")
HOME_V5=os.path.join(BASE_DIR,"backend_auto/test_backend_data/service_data","home_v5.yaml")

PERSONAL_CENTER_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "user_request.yaml")
PERSONAL_CENTER = os.path.join(BASE_DIR, "backend_auto/test_backend_data/user_data", "personal_center.yaml")

#搜索结果页-综合/百科
CONTENTV7_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_request.yaml")
CONTENTV7 = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "content_v7.yaml")

#医院主页搜索
HOSPITALSEARCH_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_request.yaml")
HOSPITALSEARCH = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "hospital_search.yaml")

#直播
LIVEYAML_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "live_request.yaml")
#直播-获取弹幕
DANMU_V2 = os.path.join(BASE_DIR, "backend_auto/test_backend_data/live_data", "danmu_v2.yaml")
#直播-主播开播
PUSH_LIVE_INFO = os.path.join(BASE_DIR, "backend_auto/test_backend_data/live_data", "pushlive_info.yaml")

#消息
MESSAGE_READ_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "conversation_request.yaml")
MESSAGE_READ = os.path.join(BASE_DIR, "backend_auto/test_backend_data/conversation_data", "message_read.yaml")

#咨询顾问
CONVERSATION_DETAIL_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "im_request.yaml")
CONVERSATION_DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/im_data", "conversation_detail.yaml")
AUTO_MSG = os.path.join(BASE_DIR, "backend_auto/test_backend_data/im_data", "auto_msg.yaml")
#消息页未读数
UNREAD_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "notification_request.yaml")
UNREAD = os.path.join(BASE_DIR, "backend_auto/test_backend_data/notification_data", "unread.yaml")
#标记为已读
READALL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/notification_data", "readall.yaml")

#商祥页-详情
JANUS_PRODUCT_DETAIL = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "product_detail.yaml")
#商祥页-sku信息
JANUS_SKU_INFO = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "sku_info.yaml")
#商祥页-收藏
SERVICE_FAVOR = os.path.join(BASE_DIR, "backend_auto/test_backend_data/service_data", "service_favor.yaml")
#商祥页-分享
SERVICES_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "services_request.yaml")
SERVICES_SHARE_DATA = os.path.join(BASE_DIR, "backend_auto/test_backend_data/services_data", "share_data.yaml")

#捜索结果页-医生/医院tab
CONTENTV6_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "search_request.yaml")
CONTENTV6 = os.path.join(BASE_DIR, "backend_auto/test_backend_data/search_data", "content_v6.yaml")


#品类聚合页面商品列表
TAG_SERVICE_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_request.yaml")
TAG_SERVICE = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "tag_service.yaml")

#社区tab签到和招募活动
CONFIG_LIST_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "feed_request.yaml")
CONFIG_LIST = os.path.join(BASE_DIR, "backend_auto/test_backend_data/feed_data", "config_list.yaml")

#社区tabfeed流
COMMUNITY_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "feed_request.yaml")
COMMUNITY = os.path.join(BASE_DIR, "backend_auto/test_backend_data/feed_data", "community.yaml")

#品类聚合页面标签和专场
POLYMER_CONFIG = os.path.join(BASE_DIR, "backend_auto/all_backend_api", "janus_request.yaml")
POLYMER = os.path.join(BASE_DIR, "backend_auto/test_backend_data/janus_data", "polymer.yaml")


if __name__ == '__main__':
    print("==========",LIVEYAML_CONFIG)
