import path_setting
from in_common.base_request import BaseRequest


class feed_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.FEED_INDEXV9_CONFIG)
        self.data = self.api_load(path_setting.CONFIG_LIST_CONFIG)
        self.data = self.api_load(path_setting.COMMUNITY_CONFIG)
        self.data = self.api_load(path_setting.FREE_RECRUIT_BANNER_CONFIG)


    def index_v9(self,tabtype,version,current_city_id,tab_id='0'):
        self.params["tabtype"] = tabtype
        self.params["version"] = version
        self.params["current_city_id"] = current_city_id
        self.params["tab_id"] = tab_id

        return self.api_send(self.data["index_v9"])

    #社区tab页签到和招募活动列表
    def config_list(self,version):
        self.params["version"] = version

        return self.api_send(self.data["config_list"])

    # 社区tab页feed流
    def community(self, version, tabtype, tags_id, tab_id):
        self.params["version"] = version
        self.params["tabtype"] = tabtype
        self.params["tags_id"] = tags_id
        self.params["tab_id"] = tab_id

        return self.api_send(self.data["community"])

    # 免费招募列表的背景图片
    def free_recruit_banner(self, version, json):
        self.params["version"] = version
        self.params["json"] = json

        return self.api_send(self.data["free_recruit_banner"])

    # 免费招募列表
    def free_recruit_list(self, version, json, tab_type, page, size):
        self.params["version"] = version
        self.params["json"] = json
        self.params["tab_type"] = tab_type
        self.params["page"] = page
        self.params["size"] = size

        return self.api_send(self.data["free_recruit_list"])

    # 免费招募活动详情
    def free_recruit_detail(self, current_city_id, id):
        self.params["current_city_id"] = current_city_id
        self.params["id"] = id

        return self.api_send(self.data["free_recruit_detail"])

    # 招募活动获取用户抽奖状态
    def user_status(self, current_city_id, recruit_id):
        self.params["current_city_id"] = current_city_id
        self.params["recruit_id"] = recruit_id

        return self.api_send(self.data["user_status"])

    # 招募活动获取中奖名单
    def winning_user_lis(self, recruit_id, json):
        self.params["recruit_id"] = recruit_id
        self.params["json"] = json

        return self.api_send(self.data["winning_user_lis"])

    # 模拟双眼皮，发型，眉形，美瞳，口红下，新增feed流
    def index_ai(self, tag_names, scan_type, offset, current_city_id):
        self.params["tag_names"] = tag_names
        self.params["scan_type"] = scan_type
        self.params["offset"] = offset
        self.params["current_city_id"] = current_city_id

        return self.api_send(self.data["index_ai"])


if __name__ == '__main__':
    # print(feed_request().index_v9("choice", "7.42.2",  "beijing"))
    #
    # #社区tab页签到和招募活动列表
    # print(feed_request().config_list("7.44.0"))
    #
    # #免费招募列表背景图片
    # print(feed_request().free_recruit_banner("7.44.1", " "))
    #
    # # 免费招募列表
    # print(feed_request().free_recruit_list("7.44.1", " ", "1", "1", "10"))
    #
    # # 免费招募活动详情
    # print(feed_request().free_recruit_detail("beijing", "43"))
    #
    # # 免费招募获取用户状态
    # print(feed_request().user_status("beijing", "43"))
    #
    # # 免费招募查看中奖名单
    # print(feed_request().winning_user_lis("44", " "))

    # print(feed_request().index_ai('["埋线双眼皮","定点双眼皮","切开双眼皮"]', 6, 2, "beijing"))
    import base64
    st = '40dc0558ffc3f3f14503104d:e7f609c9c6a64e5cfaa3c9e0'.encode()  # 默认以utf8编码
    res = base64.b64encode(st)
    print(res.decode())