import path_setting
from in_common.base_request import BaseRequest
from bs4 import BeautifulSoup


class hybrid_request(BaseRequest):
    def __init__(self):
        #百科详情页-项目聚合百科
        self.data = self.api_load(path_setting.SUBWIKI_CONFIG)
        #百科详情页-药品（仪器、材料）百科
        self.data = self.api_load(path_setting.BASEWIKI_PRODUCT_CONFIG)
        #百科详情页-品牌百科
        self.data = self.api_load(path_setting.BRAND_CONFIG)


    #百科详情页-项目聚合百科
    def sub_wiki(self, version, current_city_id, device_id = '97B6764B-2135-4761-9911-701C38CBC272'):
        self.params['current_city_id'] = current_city_id
        self.params['version'] = version

        return self.api_send(self.data['sub_wiki'])
        # return self.data

    #百科详情页-药品（仪器、材料）百科
    def basewiki_product(self, version, device_id = '97B6764B-2135-4761-9911-701C38CBC272'):
        self.params['version'] = version

        return self.api_send(self.data['basewiki_product'])

    #百科详情页-品牌百科
    def brand(self, version, device_id = '97B6764B-2135-4761-9911-701C38CBC272'):
        self.params['version'] = version

        return self.api_send(self.data['brand'])

    # 问答详情页问题详情
    def question_v1(self):
        return self.api_send(self.data['question_v1'])

    # 问答详情页--回答列表
    def question_new_answer_list(self, question_id):
        self.params['question_id'] = question_id
        return self.api_send(self.data['question_new_answer_list'])

    # 回答详情页评论点赞
    def answer_reply_vote(self, id):
        self.params['id'] = id
        return self.api_send(self.data['answer_reply_vote'])

    def answer_reply_cancel_vote(self, id):
        self.params['id'] = id
        return self.api_send(self.data['answer_reply_cancel_vote'])






if __name__ == '__main__':
    # print(self.data)
    # print(hybrid_request().sub_wiki("744.0", "beijing"))
    print(type(hybrid_request().sub_wiki("744.0", "beijing")))
    soup = BeautifulSoup(hybrid_request().sub_wiki("744.0", "beijing"), 'lxml')  # html.parser是解析器，也可是lxml
    print(soup.prettify(),'百科详情页-项目聚合百科') #输出soup对象的内容
    # print(soup.title)